/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager.command;

import java.util.List;
import java.util.Map;
import me.chancesd.pvpmanager.manager.PlayerManager;
import me.chancesd.pvpmanager.player.CombatPlayer;
import me.chancesd.pvpmanager.sdutils.command.ArgumentType;
import me.chancesd.pvpmanager.sdutils.command.BaseCommand;
import me.chancesd.pvpmanager.sdutils.command.CommandArgument;
import me.chancesd.pvpmanager.sdutils.scheduler.ScheduleUtils;
import me.chancesd.pvpmanager.setting.Lang;
import me.chancesd.pvpmanager.setting.Permissions;
import me.chancesd.pvpmanager.storage.Storage;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;

public class PvPList
extends BaseCommand {
    private final PlayerManager ph;

    public PvPList(PluginCommand pluginCommand, PlayerManager ph) {
        super(pluginCommand);
        this.ph = ph;
        this.description("List the PvP state of all players").usage("/pvplist [alloffline]").permission(Permissions.COMMAND_PVPLIST.getPermission()).argument("alloffline", ArgumentType.STRING).endArgument();
    }

    @Override
    public void execute(CommandSender sender, String label, List<CommandArgument> args) {
        boolean isPlayer = sender instanceof Player;
        if (args.isEmpty()) {
            this.sendList(sender, isPlayer);
        } else {
            CommandArgument modeArg = args.get(0);
            if (modeArg.getValue().equalsIgnoreCase("alloffline")) {
                ScheduleUtils.runAsync(() -> {
                    sender.sendMessage(Lang.PVP_LIST_TITLE.msg());
                    sender.sendMessage(String.valueOf(ChatColor.DARK_GRAY) + "Gathering all offline players with PvP disabled, please wait...");
                    sender.sendMessage(Lang.PVP_LIST_DISABLED.msg());
                    sender.sendMessage(String.valueOf(ChatColor.GRAY) + "  " + this.pvpListOffline());
                });
            } else {
                this.sendList(sender, isPlayer);
            }
        }
    }

    private void sendList(CommandSender sender, boolean isPlayer) {
        sender.sendMessage(Lang.PVP_LIST_TITLE.msg());
        sender.sendMessage(String.valueOf(ChatColor.DARK_GRAY) + "You can use " + String.valueOf(ChatColor.YELLOW) + "/pvplist alloffline" + String.valueOf(ChatColor.DARK_GRAY) + " to see the PvP status of all offline players.");
        sender.sendMessage(Lang.PVP_LIST_ENABLED.msg());
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "  " + this.pvpList(sender, true, !isPlayer));
        sender.sendMessage(Lang.PVP_LIST_DISABLED.msg());
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "  " + this.pvpList(sender, false, !isPlayer));
    }

    private String pvpListOffline() {
        StringBuilder list = new StringBuilder();
        Storage storage = this.ph.getPlugin().getStorageManager().getStorage();
        for (Map<String, Object> userData : storage.getAllUserData()) {
            String name = (String)userData.get("name");
            Object pvpstatus = userData.get("pvpstatus");
            boolean pvpState = true;
            if (pvpstatus instanceof Integer) {
                pvpState = (Integer)pvpstatus != 0;
            } else if (pvpstatus instanceof Boolean) {
                pvpState = (Boolean)pvpstatus;
            }
            if (pvpState || name == null) continue;
            list.append(name).append(", ");
        }
        if (list.isEmpty()) {
            return Lang.PVP_LIST_NO_RESULTS.msg();
        }
        list.delete(list.length() - 2, list.length());
        return list.toString();
    }

    private String pvpList(CommandSender sender, boolean enabled, boolean console) {
        StringBuilder list = new StringBuilder();
        for (CombatPlayer p : this.ph.getPlayers().values()) {
            Player player = p.getPlayer();
            if (enabled != p.hasPvPEnabled() || !console && !((Player)sender).canSee(player)) continue;
            list.append(p.getName()).append(", ");
        }
        if (list.isEmpty()) {
            return Lang.PVP_LIST_NO_RESULTS.msg();
        }
        list.delete(list.length() - 2, list.length());
        return list.toString();
    }
}

