/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager.integration.hook.worldguard;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.SessionManager;
import com.sk89q.worldguard.session.handler.Handler;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Set;
import me.chancesd.pvpmanager.integration.BaseDependency;
import me.chancesd.pvpmanager.integration.Hook;
import me.chancesd.pvpmanager.integration.hook.worldguard.WGListener;
import me.chancesd.pvpmanager.integration.hook.worldguard.WorldGuardFlagHandler;
import me.chancesd.pvpmanager.integration.type.ForceToggleDependency;
import me.chancesd.pvpmanager.integration.type.WorldGuardDependency;
import me.chancesd.pvpmanager.manager.PlayerManager;
import me.chancesd.pvpmanager.player.CombatPlayer;
import me.chancesd.pvpmanager.player.ProtectionType;
import me.chancesd.pvpmanager.sdutils.utils.Log;
import me.chancesd.pvpmanager.setting.Conf;
import me.chancesd.pvpmanager.setting.Lang;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class WorldGuardModernHook
extends BaseDependency
implements WorldGuardDependency,
ForceToggleDependency {
    private final RegionQuery regionQuery = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();

    public WorldGuardModernHook(Hook hook) {
        super(hook);
        SessionManager sessionManager = WorldGuard.getInstance().getPlatform().getSessionManager();
        for (Player player : Bukkit.getOnlinePlayers()) {
            Session session = sessionManager.get(WorldGuardPlugin.inst().wrapPlayer(player));
            try {
                Field handlersField = session.getClass().getDeclaredField("handlers");
                handlersField.setAccessible(true);
                HashMap handlers = (HashMap)handlersField.get(session);
                handlers.entrySet().removeIf(entry -> ((Handler)entry.getValue()).getClass().getName().equals(WorldGuardFlagHandler.class.getName()));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                Log.severe("Failed to remove old WG FlagHandler, flags might not work correctly until the player rejoins", e);
            }
            session.register((Handler)WorldGuardFlagHandler.FACTORY.create(session));
        }
        sessionManager.registerHandler((Handler.Factory)WorldGuardFlagHandler.FACTORY, null);
    }

    @Override
    public boolean canAttack(Player attacker, Player defender) {
        return true;
    }

    @Override
    public boolean canAttackAt(Player p, Location l) {
        return this.getWGPvPState(l) != StateFlag.State.DENY;
    }

    @Override
    public boolean hasAllowPvPFlag(Player defender) {
        return this.getWGPvPState(defender.getLocation()) == StateFlag.State.ALLOW;
    }

    @Override
    public boolean hasDenyPvPFlag(Player player) {
        return this.getWGPvPState(player.getLocation()) == StateFlag.State.DENY;
    }

    @Override
    public Set<ProtectedRegion> getRegionsAt(Location l) {
        return this.regionQuery.getApplicableRegions(BukkitAdapter.adapt((Location)l)).getRegions();
    }

    @Override
    public boolean containsRegionsAt(Location l, Set<String> regionIDs) {
        for (ProtectedRegion r : this.getRegionsAt(l)) {
            if (!regionIDs.contains(r.getId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public StateFlag.State getWGPvPState(Location l) {
        return this.regionQuery.queryState(BukkitAdapter.adapt((Location)l), null, new StateFlag[]{Flags.PVP});
    }

    @Override
    public void startListener(PlayerManager ph) {
        Bukkit.getPluginManager().registerEvents((Listener)new WGListener(ph), (Plugin)ph.getPlugin());
    }

    @Override
    public boolean shouldDisable(Player player) {
        return false;
    }

    @Override
    public boolean shouldDisable(Player damager, Player defender, ProtectionType reason) {
        if (this.hasAllowPvPFlag(defender)) {
            CombatPlayer attacker = CombatPlayer.get(damager);
            CombatPlayer attacked = CombatPlayer.get(defender);
            if (reason == ProtectionType.PVPDISABLED) {
                this.disablePvP(attacker);
                this.disablePvP(attacked);
            } else {
                this.disableNewbieProtection(attacker);
                this.disableNewbieProtection(attacked);
            }
            return true;
        }
        return false;
    }

    private void disableNewbieProtection(CombatPlayer player) {
        if (player.isNewbie()) {
            player.setNewbie(false);
            player.message(Lang.NEWBIE_FORCE_REMOVED_WG.msg());
        }
    }

    private void disablePvP(CombatPlayer player) {
        if (!player.hasPvPEnabled()) {
            player.setPvP(true);
            player.message(Lang.PVP_FORCE_ENABLED_WG.msg());
        }
    }

    @Override
    public boolean shouldDisableProtection() {
        return Conf.WORLDGUARD_OVERRIDES.asBool();
    }
}

