/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager.listener;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import me.chancesd.pvpmanager.integration.Hook;
import me.chancesd.pvpmanager.integration.type.WorldGuardDependency;
import me.chancesd.pvpmanager.manager.PlayerManager;
import me.chancesd.pvpmanager.player.CombatPlayer;
import me.chancesd.pvpmanager.player.ProtectionResult;
import me.chancesd.pvpmanager.player.ProtectionType;
import me.chancesd.pvpmanager.sdutils.utils.MCVersion;
import me.chancesd.pvpmanager.setting.Conf;
import me.chancesd.pvpmanager.setting.Lang;
import me.chancesd.pvpmanager.setting.Permissions;
import me.chancesd.pvpmanager.utils.CombatUtils;
import org.bukkit.Effect;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.Nullable;

public class EntityListener
implements Listener {
    private final PlayerManager playerHandler;
    private final WorldGuardDependency wg;
    private final Cache<LightningStrike, Location> lightningCache = CacheBuilder.newBuilder().expireAfterWrite(2L, TimeUnit.SECONDS).build();

    public EntityListener(PlayerManager ph) {
        this.playerHandler = ph;
        this.wg = (WorldGuardDependency)ph.getPlugin().getDependencyManager().getDependency(Hook.WORLDGUARD);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public final void onPlayerDamage(EntityDamageByEntityEvent event) {
        if (CombatUtils.isWorldExcluded(event.getEntity().getWorld().getName())) {
            return;
        }
        if (!CombatUtils.isPvP(event)) {
            if (!(event.getEntity() instanceof Player)) {
                return;
            }
            CombatPlayer attacked = this.playerHandler.get((Player)event.getEntity());
            if (attacked.isNewbie() && Conf.NEWBIE_GODMODE.asBool()) {
                event.setCancelled(true);
            } else {
                Entity entity = event.getDamager();
                if (entity instanceof LightningStrike) {
                    LightningStrike lightning = (LightningStrike)entity;
                    if (!this.lightningCache.asMap().containsKey(lightning)) {
                        return;
                    }
                    if (!attacked.hasPvPEnabled() || attacked.isNewbie() || attacked.hasRespawnProtection()) {
                        event.setCancelled(true);
                    }
                }
            }
            return;
        }
        Player attacker = this.getAttacker(event.getDamager());
        Player attacked = (Player)event.getEntity();
        if (attacker == null) {
            return;
        }
        ProtectionResult result = this.playerHandler.checkProtection(attacker, attacked);
        if (result.isProtected()) {
            event.setCancelled(true);
            Lang.messageProtection(result, attacker, attacked);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public final void onPlayerDamageOverride(EntityDamageByEntityEvent event) {
        if (!CombatUtils.isPvP(event) || CombatUtils.isWorldExcluded(event.getEntity().getWorld().getName()) || !event.isCancelled()) {
            return;
        }
        Player attacker = this.getAttacker(event.getDamager());
        if (attacker == null) {
            return;
        }
        if (this.playerHandler.checkProtection(attacker, (Player)event.getEntity()).type() == ProtectionType.FAIL_OVERRIDE) {
            event.setCancelled(false);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onPlayerDamageMonitor(EntityDamageByEntityEvent event) {
        if (!CombatUtils.isPvP(event) || CombatUtils.isWorldExcluded(event.getEntity().getWorld().getName())) {
            return;
        }
        Player attacker = this.getAttacker(event.getDamager());
        Player attacked = (Player)event.getEntity();
        this.processDamage(attacker, attacked);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public final void onEntityCombust(EntityCombustByEntityEvent event) {
        if (CombatUtils.isWorldExcluded(event.getEntity().getWorld().getName())) {
            return;
        }
        if (!CombatUtils.isPvP(event)) {
            Player player;
            Entity entity = event.getEntity();
            if (entity instanceof Player && this.playerHandler.get(player = (Player)entity).isNewbie() && Conf.NEWBIE_GODMODE.asBool()) {
                event.setCancelled(true);
            }
            return;
        }
        Player attacker = this.getAttacker(event.getCombuster());
        Player attacked = (Player)event.getEntity();
        if (attacker == null) {
            return;
        }
        if (!this.playerHandler.canAttack(attacker, attacked)) {
            event.setCancelled(true);
        }
    }

    public void processDamage(Player attacker, Player defender) {
        CombatPlayer pvpAttacker = this.playerHandler.get(attacker);
        CombatPlayer pvpDefender = this.playerHandler.get(defender);
        if (Conf.PVP_BLOOD.asBool()) {
            defender.getWorld().playEffect(defender.getLocation(), Effect.STEP_SOUND, (Object)Material.REDSTONE_BLOCK);
        }
        this.disableActions(attacker, defender, pvpAttacker, pvpDefender);
        if (Conf.COMBAT_TAG_ENABLED.asBool()) {
            if (Conf.VULNERABLE_ENABLED.asBool() && this.wg != null && !Conf.VULNERABLE_RENEW_TAG.asBool() && this.wg.hasDenyPvPFlag(attacker) && this.wg.hasDenyPvPFlag(defender)) {
                return;
            }
            pvpAttacker.tag(true, pvpDefender);
            pvpDefender.tag(false, pvpAttacker);
        }
    }

    private void disableActions(Player attacker, Player defender, CombatPlayer pvpAttacker, CombatPlayer pvpDefender) {
        boolean hasExemptPerm = pvpAttacker.hasPerm(Permissions.EXEMPT_DISABLE_ACTIONS);
        if (Conf.DISABLE_FLY.asBool()) {
            if (CombatUtils.canFly(attacker) && !hasExemptPerm) {
                pvpAttacker.disableFly();
            }
            if (CombatUtils.canFly(defender) && !pvpDefender.hasPerm(Permissions.EXEMPT_DISABLE_ACTIONS)) {
                pvpDefender.disableFly();
            }
        }
        if (Conf.DISABLE_ELYTRA.asBool()) {
            if (!hasExemptPerm) {
                CombatUtils.checkGlide(attacker);
            }
            if (!pvpDefender.hasPerm(Permissions.EXEMPT_DISABLE_ACTIONS)) {
                CombatUtils.checkGlide(defender);
            }
        }
        if (hasExemptPerm) {
            return;
        }
        if (Conf.DISABLE_GAMEMODE.asBool() && attacker.getGameMode() != GameMode.SURVIVAL) {
            attacker.setGameMode(GameMode.SURVIVAL);
        }
        if (Conf.DISABLE_DISGUISE.asBool()) {
            this.playerHandler.getPlugin().getDependencyManager().disableDisguise(attacker);
        }
        if (Conf.DISABLE_INVISIBILITY.asBool() && attacker.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
            attacker.removePotionEffect(PotionEffectType.INVISIBILITY);
        }
        if (Conf.DISABLE_GODMODE.asBool()) {
            this.playerHandler.getPlugin().getDependencyManager().disableGodMode(attacker);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public final void onPotionSplash(PotionSplashEvent event) {
        if (!this.shouldCheckPotionEvent(event)) {
            return;
        }
        ThrownPotion potion = event.getPotion();
        Player player = (Player)potion.getShooter();
        if (player == null) {
            return;
        }
        for (LivingEntity e : event.getAffectedEntities()) {
            Player attacked;
            ProtectionResult result;
            if (e.getType() != EntityType.PLAYER || e.equals((Object)player) || !(result = this.playerHandler.checkProtection(player, attacked = (Player)e)).isProtected()) continue;
            event.setIntensity((LivingEntity)attacked, 0.0);
            Lang.messageProtection(result, player, attacked);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onPotionSplashMonitor(PotionSplashEvent event) {
        if (!this.shouldCheckPotionEvent(event)) {
            return;
        }
        ThrownPotion potion = event.getPotion();
        Player player = (Player)potion.getShooter();
        for (LivingEntity e : event.getAffectedEntities()) {
            if (e.getType() != EntityType.PLAYER || e.equals((Object)player)) continue;
            Player attacked = (Player)e;
            this.processDamage(player, attacked);
        }
    }

    private boolean shouldCheckPotionEvent(PotionSplashEvent event) {
        if (CombatUtils.isWorldExcluded(event.getEntity().getWorld().getName())) {
            return false;
        }
        ThrownPotion potion = event.getPotion();
        if (event.getAffectedEntities().isEmpty() || potion.getEffects().isEmpty() || !(potion.getShooter() instanceof Player)) {
            return false;
        }
        for (PotionEffect effect : potion.getEffects()) {
            if (CombatUtils.isHarmfulPotion(effect.getType())) continue;
            return false;
        }
        return true;
    }

    @EventHandler(ignoreCancelled=true)
    public void onLightningStrike(LightningStrikeEvent event) {
        if (CombatUtils.isWorldExcluded(event.getLightning().getWorld().getName())) {
            return;
        }
        if (!MCVersion.isAtLeast(MCVersion.V1_13_1)) {
            return;
        }
        if (event.getCause() != LightningStrikeEvent.Cause.TRIDENT) {
            return;
        }
        this.lightningCache.put((Object)event.getLightning(), (Object)event.getLightning().getLocation());
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockIgnite(BlockIgniteEvent event) {
        if (event.getCause() != BlockIgniteEvent.IgniteCause.LIGHTNING) {
            return;
        }
        if (CombatUtils.isWorldExcluded(event.getBlock().getWorld().getName())) {
            return;
        }
        Entity ignitingEntity = event.getIgnitingEntity();
        if (ignitingEntity instanceof LightningStrike) {
            LightningStrike lightningStrike = (LightningStrike)ignitingEntity;
            if (this.lightningCache.asMap().containsKey(ignitingEntity)) {
                for (Entity entity : lightningStrike.getNearbyEntities(2.0, 2.0, 2.0)) {
                    Player player;
                    CombatPlayer attacked;
                    if (!(entity instanceof Player) || (attacked = this.playerHandler.get(player = (Player)entity)).hasPvPEnabled() && !attacked.isNewbie() && !attacked.hasRespawnProtection()) continue;
                    event.setCancelled(true);
                    return;
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onProjectileHitEvent(ProjectileHitEvent event) {
        Projectile entity = event.getEntity();
        ProjectileSource shooter = entity.getShooter();
        if (!(shooter instanceof Player)) {
            return;
        }
        Player player = (Player)shooter;
        CombatPlayer pvPlayer = this.playerHandler.get(player);
        if (pvPlayer.isInCombat() && (Conf.PEARL_RENEW_TAG.asBool() && entity.getType() == EntityType.ENDER_PEARL || Conf.WIND_CHARGE_RENEW_TAG.asBool() && entity.getType() == EntityType.WIND_CHARGE)) {
            CombatPlayer enemy = pvPlayer.getEnemy();
            pvPlayer.tag(true, enemy != null ? enemy : pvPlayer);
        }
    }

    @Nullable
    private Player getAttacker(Entity damager) {
        if (damager instanceof Player) {
            Player player = (Player)damager;
            return player;
        }
        if (damager instanceof Projectile) {
            Projectile projectile = (Projectile)damager;
            return (Player)projectile.getShooter();
        }
        if (damager instanceof TNTPrimed) {
            TNTPrimed tnt = (TNTPrimed)damager;
            return (Player)tnt.getSource();
        }
        return (Player)((AreaEffectCloud)damager).getSource();
    }
}

