/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager.listener;

import me.chancesd.pvpmanager.manager.PlayerManager;
import me.chancesd.pvpmanager.player.ProtectionResult;
import me.chancesd.pvpmanager.sdutils.utils.Utils;
import me.chancesd.pvpmanager.utils.CombatUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityKnockbackByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;

public class EntityListener1_20_4
implements Listener {
    private final PlayerManager ph;

    public EntityListener1_20_4(PlayerManager ph) {
        this.ph = ph;
        this.registerKnockBackEvent();
    }

    private void registerKnockBackEvent() {
        if (Utils.isPaper()) {
            Utils.registerEvent((Plugin)this.ph.getPlugin(), this, com.destroystokyo.paper.event.entity.EntityKnockbackByEntityEvent.class, event -> this.onPlayerKnockback((Cancellable)event, event.getHitBy(), (Entity)event.getEntity()));
        } else {
            Utils.registerEvent((Plugin)this.ph.getPlugin(), this, EntityKnockbackByEntityEvent.class, event -> this.onPlayerKnockback((Cancellable)event, event.getSourceEntity(), (Entity)event.getEntity()));
        }
    }

    private void onPlayerKnockback(Cancellable event, Entity entityAttacker, Entity entityDefender) {
        if (CombatUtils.isWorldExcluded(entityDefender.getWorld().getName())) {
            return;
        }
        Player attacker = null;
        Player attacked = null;
        if (entityDefender instanceof Player) {
            Projectile proj;
            ProjectileSource projSource;
            Player defender;
            attacked = defender = (Player)entityDefender;
            if (entityAttacker instanceof Player) {
                Player playerAttacker;
                attacker = playerAttacker = (Player)entityAttacker;
            }
            if (entityAttacker instanceof Projectile && (projSource = (proj = (Projectile)entityAttacker).getShooter()) instanceof Player) {
                Player player = (Player)projSource;
                if (!projSource.equals((Object)attacked)) {
                    attacker = player;
                }
            }
        }
        if (attacked == null || attacker == null) {
            return;
        }
        ProtectionResult result = this.ph.checkProtection(attacker, attacked);
        if (result.isProtected()) {
            event.setCancelled(true);
        }
    }
}

