/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager.player.nametag;

import java.util.UUID;
import me.chancesd.pvpmanager.player.CombatPlayer;
import me.chancesd.pvpmanager.player.nametag.NameTag;
import me.chancesd.pvpmanager.sdutils.utils.Log;
import me.chancesd.pvpmanager.sdutils.utils.MCVersion;
import me.chancesd.pvpmanager.setting.Conf;
import org.bukkit.ChatColor;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;

public class BukkitNameTag
extends NameTag {
    private Team inCombat;
    private Team pvpOnTeam;
    private Team pvpOffTeam;
    private Team previousTeam;
    private String previousTeamName;
    @NotNull
    private final String combatTeamID;
    private final Scoreboard scoreboard;
    private static final String PVPOFF = "PvPOff";
    private static final String PVPON = "PvPOn";
    private static final String HEALTHOBJ = "PvP_Health";
    private Objective health;

    public BukkitNameTag(CombatPlayer p) {
        super(p);
        this.combatTeamID = "PVP-" + this.processPlayerID(this.pvPlayer.getUUID());
        this.scoreboard = this.pvPlayer.getPlayer().getScoreboard();
        this.setup();
    }

    private void setup() {
        this.setupCombatTeam();
        if (Conf.TOGGLE_NAMETAG_ENABLED.asBool()) {
            this.pvpOnTeam = this.setupToggleTeam(this.pvpOnPrefix, PVPON);
            this.pvpOffTeam = this.setupToggleTeam(this.pvpOffPrefix, PVPOFF);
            this.setPvP(this.pvPlayer.hasPvPEnabled());
        }
        if (Conf.HEALTH_BELOW_NAME.asBool() && (this.health == null || this.scoreboard.getObjective(HEALTHOBJ) == null)) {
            if (this.scoreboard.getObjective(HEALTHOBJ) != null) {
                this.health = this.scoreboard.getObjective(HEALTHOBJ);
            } else if (MCVersion.isAtLeast(MCVersion.V1_19)) {
                this.health = this.scoreboard.registerNewObjective(HEALTHOBJ, Criteria.HEALTH, Conf.HEALTH_BELOW_NAME_SYMBOL.asString(), RenderType.HEARTS);
                this.health.setDisplaySlot(DisplaySlot.BELOW_NAME);
            } else {
                this.health = this.scoreboard.registerNewObjective(HEALTHOBJ, "health");
                this.health.setDisplayName(Conf.HEALTH_BELOW_NAME_SYMBOL.asString());
                this.health.setDisplaySlot(DisplaySlot.BELOW_NAME);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Team registerTeam(String teamID) {
        Scoreboard scoreboard = this.scoreboard;
        synchronized (scoreboard) {
            if (this.scoreboard.getTeam(teamID) != null) {
                return this.scoreboard.getTeam(teamID);
            }
            return this.scoreboard.registerNewTeam(teamID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToTeam(Team team, String entry) {
        Scoreboard scoreboard = this.scoreboard;
        synchronized (scoreboard) {
            team.addEntry(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromTeam(Team team, String entry) {
        Scoreboard scoreboard = this.scoreboard;
        synchronized (scoreboard) {
            team.removeEntry(entry);
        }
    }

    private void setupCombatTeam() {
        if (this.combatPrefix.isEmpty() && this.combatSuffix.isEmpty()) {
            return;
        }
        this.inCombat = this.registerTeam(this.combatTeamID);
        Log.debug("Creating combat team with name " + this.combatTeamID);
        this.inCombat.setPrefix(this.combatPrefix.replace("%pvpmanager_combat_timeleft%s", "").replace("\u00a78(\u00a77s\u00a78) ", ""));
        this.inCombat.setSuffix(this.combatSuffix.replace(" \u00a7f%pvpmanager_player_health%\u00a7c\u2764", ""));
        this.setTeamColor(this.inCombat, this.combatPrefix);
    }

    private void setTeamColor(Team team, String teamPrefix) {
        ChatColor nameColor;
        if (MCVersion.isAtLeast(MCVersion.V1_13) && (nameColor = this.getLastColor(teamPrefix)) != null) {
            team.setColor(nameColor);
        }
    }

    private Team setupToggleTeam(String teamPrefix, @NotNull String teamName) {
        if (teamPrefix.isEmpty()) {
            return null;
        }
        Team toggleTeam = this.registerTeam(teamName);
        toggleTeam.setCanSeeFriendlyInvisibles(false);
        toggleTeam.setPrefix(teamPrefix);
        this.setTeamColor(toggleTeam, teamPrefix);
        return toggleTeam;
    }

    private String processPlayerID(UUID uuid) {
        String idResult = uuid.toString().replace("-", "");
        if (idResult.startsWith("000000000000")) {
            return idResult.substring(17, 29);
        }
        return idResult.substring(0, 12);
    }

    private ChatColor getLastColor(String string) {
        String lastColors = ChatColor.getLastColors((String)string);
        if (lastColors.isEmpty()) {
            return null;
        }
        return ChatColor.getByChar((String)lastColors.replace("\u00a7", ""));
    }

    @Override
    public final synchronized void setInCombat() {
        this.storePreviousTeam();
        try {
            if (this.inCombat != null) {
                this.addToTeam(this.inCombat, this.pvPlayer.getName());
            }
        }
        catch (IllegalStateException e) {
            Log.severe("Failed to add player to combat team");
            Log.info("This warning can be ignored but if it happens often it means one of your plugins is removing PvPManager teams and causing a conflict");
        }
    }

    private void storePreviousTeam() {
        Team team = this.scoreboard.getEntryTeam(this.pvPlayer.getName());
        if (team != null && !team.equals((Object)this.inCombat)) {
            this.previousTeam = team;
            this.previousTeamName = team.getName();
        }
    }

    @Override
    public final synchronized void restoreNametag() {
        try {
            if (this.previousTeamName != null && this.scoreboard.getTeam(this.previousTeamName) != null) {
                this.addToTeam(this.previousTeam, this.pvPlayer.getName());
            } else if (this.inCombat != null) {
                this.removeFromTeam(this.inCombat, this.pvPlayer.getName());
            }
        }
        catch (IllegalStateException e) {
            Log.warning("Error restoring nametag for: " + this.pvPlayer.getName(), e);
        }
        finally {
            this.previousTeamName = null;
        }
    }

    @Override
    public final synchronized void setPvP(boolean state) {
        if (state) {
            if (this.pvpOnTeam == null) {
                this.restoreNametag();
            } else {
                this.addToTeam(this.pvpOnTeam, this.pvPlayer.getName());
            }
        } else if (this.pvpOffTeam == null) {
            this.restoreNametag();
        } else {
            this.addToTeam(this.pvpOffTeam, this.pvPlayer.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void cleanup() {
        if (this.inCombat == null) {
            return;
        }
        try {
            Scoreboard scoreboard = this.scoreboard;
            synchronized (scoreboard) {
                if (this.teamExists(this.combatTeamID)) {
                    Log.debug("Unregistering team: " + this.inCombat.getName());
                    this.inCombat.unregister();
                    this.inCombat = null;
                }
            }
        }
        catch (IllegalStateException e) {
            Log.severe("Team was already unregistered for player: " + this.pvPlayer.getName(), e);
        }
    }

    private boolean teamExists(String teamID) {
        return this.scoreboard.getTeam(teamID) != null;
    }
}

