/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager.sdutils.command;

import me.chancesd.pvpmanager.sdutils.utils.NCDuration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class CommandArgument {
    private final String name;
    private final String value;

    public CommandArgument(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public int getAsInt() {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Not a valid integer: " + this.value);
        }
    }

    public double getAsDouble() {
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Not a valid number: " + this.value);
        }
    }

    public boolean getAsBoolean() {
        if ("true".equalsIgnoreCase(this.value) || "yes".equalsIgnoreCase(this.value) || "on".equalsIgnoreCase(this.value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(this.value) || "no".equalsIgnoreCase(this.value) || "off".equalsIgnoreCase(this.value)) {
            return false;
        }
        throw new IllegalStateException("Not a valid boolean: " + this.value);
    }

    public boolean isWildcard() {
        return "*".equals(this.value);
    }

    public boolean isAllPlayers() {
        return this.isWildcard();
    }

    public Player getAsPlayer() {
        return Bukkit.getPlayer((String)this.value);
    }

    public Player getAsPlayerOrWildcard() {
        return this.isWildcard() ? null : Bukkit.getPlayer((String)this.value);
    }

    public OfflinePlayer getAsOfflinePlayer() {
        Player onlinePlayer = Bukkit.getPlayer((String)this.value);
        if (onlinePlayer != null) {
            return onlinePlayer;
        }
        return Bukkit.getOfflinePlayer((String)this.value);
    }

    public World getAsWorld() {
        World world = Bukkit.getWorld((String)this.value);
        if (world == null) {
            throw new IllegalStateException("World not found: " + this.value);
        }
        return world;
    }

    public Material getAsMaterial() {
        try {
            return Material.valueOf((String)this.value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Invalid material: " + this.value);
        }
    }

    public NCDuration getAsDuration() {
        try {
            return NCDuration.parseDuration(this.value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

