/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager.sdutils.database;

import java.io.File;
import me.chancesd.pvpmanager.sdutils.utils.Log;
import org.bukkit.configuration.ConfigurationSection;

public class DatabaseConfigBuilder {
    private static final String DATABASE_FIELD = "Database";
    private static final String USERNAME_FIELD = "Username";
    private static final String PASSWORD_FIELD = "Password";
    private String driver;
    private String url;
    private String database;
    private String user;
    private String password;
    private String file;
    private DatabaseType type;

    public DatabaseConfigBuilder(File sqliteFile) {
        this.driver("org.sqlite.SQLiteDataSource").type(DatabaseType.SQLITE).sqlite(sqliteFile);
    }

    public DatabaseConfigBuilder(ConfigurationSection section) {
        DatabaseType dbType = DatabaseConfigBuilder.getDBTypeFrom(section);
        String newURL = String.format("%s:%d", section.getString("Host"), section.getInt("Port"));
        if (dbType == DatabaseType.MYSQL) {
            this.driver("com.mysql.jdbc.Driver").type(DatabaseType.MYSQL).url(newURL).database(section.getString(DATABASE_FIELD)).user(section.getString(USERNAME_FIELD)).password(section.getString(PASSWORD_FIELD));
        }
    }

    public DatabaseConfigBuilder(ConfigurationSection section, File backup) {
        this(section, backup, DatabaseConfigBuilder.getDBTypeFrom(section));
    }

    public DatabaseConfigBuilder(ConfigurationSection section, File backup, DatabaseType dbType) {
        if (dbType == DatabaseType.MYSQL) {
            ConfigurationSection mysql = section.getConfigurationSection("MySQL");
            if (mysql == null) {
                throw new IllegalArgumentException("The MySQL config section is missing");
            }
            String newURL = String.format("%s:%d", mysql.getString("Host"), mysql.getInt("Port"));
            this.driver("com.mysql.jdbc.Driver").type(DatabaseType.MYSQL).url(newURL).database(mysql.getString(DATABASE_FIELD)).user(mysql.getString(USERNAME_FIELD)).password(mysql.getString(PASSWORD_FIELD));
        } else {
            this.driver("org.sqlite.SQLiteDataSource").type(DatabaseType.SQLITE).sqlite(backup);
        }
    }

    private static DatabaseType getDBTypeFrom(ConfigurationSection section) {
        DatabaseType databaseType;
        String dbType = section.getString("Type", "SQLite").toUpperCase();
        try {
            databaseType = DatabaseType.valueOf(dbType);
        }
        catch (IllegalArgumentException e) {
            Log.severe("The database type you specified in the config does not exist: " + dbType + ". Defaulting to SQLite");
            databaseType = DatabaseType.SQLITE;
        }
        return databaseType;
    }

    public DatabaseConfigBuilder driver(String newDriver) {
        this.driver = newDriver;
        return this;
    }

    public DatabaseConfigBuilder url(String newURL) {
        this.url = newURL;
        return this;
    }

    public DatabaseConfigBuilder database(String newDatabase) {
        this.database = newDatabase;
        return this;
    }

    public DatabaseConfigBuilder user(String newUser) {
        this.user = newUser;
        return this;
    }

    public DatabaseConfigBuilder password(String newPassword) {
        this.password = newPassword;
        return this;
    }

    public DatabaseConfigBuilder sqlite(File newFile) {
        this.file = newFile.getPath();
        return this;
    }

    public DatabaseConfigBuilder type(DatabaseType newType) {
        this.type = newType;
        return this;
    }

    public String getFile() {
        return this.file;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public DatabaseType getType() {
        return this.type;
    }

    public static enum DatabaseType {
        SQLITE,
        MYSQL;

    }
}

