/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager.sdutils.display.chat;

import java.util.ArrayList;
import java.util.List;
import me.chancesd.pvpmanager.sdutils.utils.ChatUtils;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChatLine {
    private final List<Component> components;

    public ChatLine(@NotNull String text, @Nullable ClickAction clickAction, @Nullable HoverAction hoverAction) {
        this.components = new ArrayList<Component>();
        this.components.add(new Component(text, clickAction, hoverAction));
    }

    public ChatLine(@NotNull String text) {
        this(text, null, null);
    }

    private ChatLine(@NotNull List<Component> components) {
        this.components = new ArrayList<Component>(components);
    }

    private ComponentBuilder toComponentBuilder() {
        ComponentBuilder mainComponent = new ComponentBuilder();
        for (Component comp : this.components) {
            TextComponent textComp = new TextComponent(ChatUtils.colorizeComponent(comp.text));
            if (comp.clickAction != null) {
                textComp.setClickEvent(new ClickEvent(comp.clickAction.type, comp.clickAction.value));
            }
            if (comp.hoverAction != null) {
                textComp.setHoverEvent(new HoverEvent(comp.hoverAction.type, new Content[]{new Text(ChatUtils.colorizeComponent(comp.hoverAction.value))}));
            }
            mainComponent.append((BaseComponent)textComp);
        }
        return mainComponent;
    }

    public BaseComponent toComponent() {
        return this.toComponentBuilder().build();
    }

    public BaseComponent[] toComponentArray() {
        return this.toComponentBuilder().create();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getPlainText() {
        StringBuilder result = new StringBuilder();
        for (Component comp : this.components) {
            result.append(comp.text);
        }
        return result.toString();
    }

    private static class Component {
        private final String text;
        private final ClickAction clickAction;
        private final HoverAction hoverAction;

        public Component(@NotNull String text, @Nullable ClickAction clickAction, @Nullable HoverAction hoverAction) {
            this.text = text;
            this.clickAction = clickAction;
            this.hoverAction = hoverAction;
        }
    }

    public static class ClickAction {
        private final ClickEvent.Action type;
        private final String value;

        public ClickAction(ClickEvent.Action type, String value) {
            this.type = type;
            this.value = value;
        }

        public static ClickAction runCommand(String command) {
            return new ClickAction(ClickEvent.Action.RUN_COMMAND, command);
        }

        public static ClickAction suggestCommand(String command) {
            return new ClickAction(ClickEvent.Action.SUGGEST_COMMAND, command);
        }

        public static ClickAction openUrl(String url) {
            return new ClickAction(ClickEvent.Action.OPEN_URL, url);
        }
    }

    public static class HoverAction {
        private final HoverEvent.Action type;
        private final String value;

        public HoverAction(HoverEvent.Action type, String value) {
            this.type = type;
            this.value = value;
        }

        public static HoverAction showText(String text) {
            return new HoverAction(HoverEvent.Action.SHOW_TEXT, text);
        }
    }

    public static class Builder {
        private final List<Component> components = new ArrayList<Component>();

        public Builder add(@NotNull String text, @Nullable ClickAction clickAction, @Nullable HoverAction hoverAction) {
            this.components.add(new Component(text, clickAction, hoverAction));
            return this;
        }

        public Builder add(@NotNull String text) {
            return this.add(text, null, null);
        }

        public Builder addClickable(@NotNull String text, @NotNull ClickAction clickAction, @Nullable HoverAction hoverAction) {
            return this.add(text, clickAction, hoverAction);
        }

        public Builder addClickable(@NotNull String text, @NotNull ClickAction clickAction, @NotNull String hoverText) {
            return this.add(text, clickAction, HoverAction.showText(hoverText));
        }

        public ChatLine build() {
            return new ChatLine(this.components);
        }
    }
}

