/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager.sdutils.updater;

import java.io.File;
import me.chancesd.pvpmanager.sdutils.utils.Log;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public abstract class Updater {
    protected String versionName;
    protected String versionLink;
    protected String versionType;
    protected String versionGameVersion;
    private static final String[] TAGS = new String[]{"-DEV", "-PRE", "-SNAPSHOT", "-BETA"};
    private UpdateResult result = UpdateResult.SUCCESS;
    private final Thread thread;
    private final Plugin plugin;
    private final int id;
    private final UpdateType type;
    private final File file;
    private final String projectSlug;

    protected Updater(Plugin plugin, int id, UpdateType type, String projectSlug) {
        this.plugin = plugin;
        this.id = id;
        this.type = type;
        this.projectSlug = projectSlug;
        if (!Bukkit.getUpdateFolderFile().exists()) {
            Bukkit.getUpdateFolderFile().mkdirs();
        }
        this.file = new File(Bukkit.getUpdateFolderFile(), plugin.getName() + ".jar");
        this.thread = new Thread(this::runUpdater);
    }

    public final UpdateResult getResult() {
        this.waitForThread();
        return this.result;
    }

    protected final void runUpdater() {
        if (!this.read()) {
            return;
        }
        if (!this.versionName.matches("^\\d.*")) {
            this.setResult(UpdateResult.FAIL_NOVERSION);
            return;
        }
        if (this.versionCheck(this.versionName)) {
            if (this.versionLink != null && this.getType() == UpdateType.DOWNLOAD) {
                try {
                    this.downloadFile();
                }
                catch (Exception e) {
                    Log.warning("The auto-updater tried to download a new update, but was unsuccessful.");
                    this.setResult(UpdateResult.FAIL_DOWNLOAD);
                }
            } else {
                this.setResult(UpdateResult.UPDATE_AVAILABLE);
            }
        } else {
            this.setResult(UpdateResult.NO_UPDATE);
        }
    }

    protected final void waitForThread() {
        if (this.thread.isAlive()) {
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        }
    }

    protected final String[] getVersionArray(String version) {
        String[] versionArray = this.hasTag(version) ? version.replaceAll("(-.+)", "").split("\\.") : version.split("\\.");
        return versionArray;
    }

    protected boolean hasTag(String version) {
        for (String string : TAGS) {
            if (!version.contains(string)) continue;
            return true;
        }
        return false;
    }

    protected final boolean versionCheck(String remoteVersion) {
        String version = this.plugin.getDescription().getVersion();
        if (remoteVersion.equalsIgnoreCase(version)) {
            return false;
        }
        String[] remote = this.getVersionArray(remoteVersion);
        String[] local = this.getVersionArray(version);
        int length = Math.max(local.length, remote.length);
        try {
            for (int i = 0; i < length; ++i) {
                int remoteNumber;
                int localNumber = i < local.length ? Integer.parseInt(local[i]) : 0;
                int n = remoteNumber = i < remote.length ? Integer.parseInt(remote[i]) : 0;
                if (remoteNumber > localNumber) {
                    return true;
                }
                if (remoteNumber >= localNumber) continue;
                return false;
            }
        }
        catch (NumberFormatException ex) {
            Log.warning("Error reading version number!");
        }
        return this.hasTag(version);
    }

    protected final Thread getThread() {
        return this.thread;
    }

    protected final Plugin getPlugin() {
        return this.plugin;
    }

    protected final int getId() {
        return this.id;
    }

    public final UpdateType getType() {
        return this.type;
    }

    protected final File getFile() {
        return this.file;
    }

    public String getProjectSlug() {
        return this.projectSlug;
    }

    protected final void setResult(UpdateResult result) {
        this.result = result;
    }

    public final String getLatestName() {
        this.waitForThread();
        return this.versionName;
    }

    public final String getLatestFileLink() {
        this.waitForThread();
        return this.versionLink;
    }

    public final String getLatestType() {
        this.waitForThread();
        return this.versionType;
    }

    public final String getLatestGameVersion() {
        this.waitForThread();
        return this.versionGameVersion;
    }

    public final Updater check() {
        this.thread.start();
        return this;
    }

    public abstract String getUpdateLink();

    protected abstract boolean read();

    public abstract boolean downloadFile();

    public static enum UpdateResult {
        SUCCESS,
        NO_UPDATE,
        FAIL_DOWNLOAD,
        FAIL_DBO,
        FAIL_NOVERSION,
        FAIL_BADID,
        UPDATE_AVAILABLE;

    }

    public static enum UpdateType {
        VERSION_CHECK,
        DOWNLOAD;

    }
}

