/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager.sdutils.utils;

import java.util.List;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.chancesd.pvpmanager.sdutils.utils.DefaultFontInfo;
import me.clip.placeholderapi.PlaceholderAPI;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChatUtils {
    private static final Pattern HEX_PATTERN = Pattern.compile("&?(#[a-fA-F0-9]{6})");
    private static final boolean USE_PLACEHOLDERAPI = ChatUtils.checkForPlaceholderAPI();
    private static final boolean HEX_SUPPORTED = ChatUtils.checkForBungeeAPI();
    private static final int CENTER_PX = 154;

    private ChatUtils() {
    }

    private static boolean checkForPlaceholderAPI() {
        return Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI");
    }

    private static boolean checkForBungeeAPI() {
        try {
            net.md_5.bungee.api.ChatColor.of((String)"#FFFFFF");
        }
        catch (NoClassDefFoundError | NoSuchMethodError e) {
            return false;
        }
        return true;
    }

    @NotNull
    public static String setPlaceholders(@Nullable Player player, @NotNull String message) {
        if (USE_PLACEHOLDERAPI) {
            try {
                return PlaceholderAPI.setPlaceholders((Player)player, (String)message);
            }
            catch (NoClassDefFoundError e) {
                return message;
            }
        }
        return message;
    }

    @NotNull
    public static String setPlaceholders(@Nullable Player player, @NotNull String message, @NotNull BiFunction<Player, String, String> fallbackProcessor) {
        if (USE_PLACEHOLDERAPI) {
            try {
                return PlaceholderAPI.setPlaceholders((Player)player, (String)message);
            }
            catch (NoClassDefFoundError e) {
                return fallbackProcessor.apply(player, message);
            }
        }
        return fallbackProcessor.apply(player, message);
    }

    @NotNull
    public static String colorize(@NotNull String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)ChatUtils.colorizeHex(message));
    }

    @NotNull
    public static String colorizeAndProcess(@Nullable Player player, @NotNull String message) {
        return ChatUtils.colorize(ChatUtils.setPlaceholders(player, message));
    }

    @NotNull
    public static BaseComponent[] colorizeComponent(@NotNull String message) {
        return TextComponent.fromLegacyText((String)ChatUtils.colorize(message));
    }

    @NotNull
    private static String colorizeHex(@NotNull String message) {
        Matcher matcher = HEX_PATTERN.matcher(message);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String hexColor = matcher.group(1);
            if (!HEX_SUPPORTED) {
                int COLOR_CHAR = 167;
                matcher.appendReplacement(buffer, "\u00a7x\u00a7" + hexColor.charAt(0) + "\u00a7" + hexColor.charAt(1) + "\u00a7" + hexColor.charAt(2) + "\u00a7" + hexColor.charAt(3) + "\u00a7" + hexColor.charAt(4) + "\u00a7" + hexColor.charAt(5));
                continue;
            }
            matcher.appendReplacement(buffer, net.md_5.bungee.api.ChatColor.of((String)hexColor).toString());
        }
        return matcher.appendTail(buffer).toString();
    }

    public static void send(@NotNull CommandSender sender, @NotNull String message) {
        sender.sendMessage(ChatUtils.colorize(message));
    }

    public static List<String> getMatchingEntries(String token, List<String> toFilter) {
        return toFilter.stream().filter(s -> s.toLowerCase().contains(token.toLowerCase())).collect(Collectors.toList());
    }

    public static int estimateVisualLength(@NotNull String message) {
        String cleanMessage = ChatColor.stripColor((String)ChatUtils.colorize(message));
        return cleanMessage.length();
    }

    public static boolean isLineTooLong(@NotNull String message, int maxLength) {
        return ChatUtils.estimateVisualLength(message) > maxLength;
    }

    public static boolean isLineTooLong(@NotNull String message) {
        return ChatUtils.isLineTooLong(message, 50);
    }

    public static String centerMessage(Player player, String message) {
        if (message == null || message.equals("")) {
            player.sendMessage("");
        }
        message = ChatUtils.colorize(message);
        int messagePxSize = 0;
        boolean previousCode = false;
        boolean isBold = false;
        for (char c : message.toCharArray()) {
            if (c == '\u00a7') {
                previousCode = true;
                continue;
            }
            if (previousCode) {
                previousCode = false;
                if (c == 'l' || c == 'L') {
                    isBold = true;
                    continue;
                }
                isBold = false;
                continue;
            }
            DefaultFontInfo dFI = DefaultFontInfo.getDefaultFontInfo(c);
            messagePxSize += isBold ? dFI.getBoldLength() : dFI.getLength();
            ++messagePxSize;
        }
        int halvedMessageSize = messagePxSize / 2;
        int toCompensate = 154 - halvedMessageSize;
        int spaceLength = DefaultFontInfo.SPACE.getLength() + 1;
        StringBuilder sb = new StringBuilder();
        for (int compensated = 0; compensated < toCompensate; compensated += spaceLength) {
            sb.append(" ");
        }
        return sb.toString() + message;
    }
}

