/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager.utils;

import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.chancesd.pvpmanager.PvPManager;
import me.chancesd.pvpmanager.integration.hook.placeholderapi.PlaceholderProcessor;
import me.chancesd.pvpmanager.sdutils.scheduler.ScheduleUtils;
import me.chancesd.pvpmanager.sdutils.utils.ChatUtils;
import me.chancesd.pvpmanager.sdutils.utils.Log;
import me.chancesd.pvpmanager.sdutils.utils.MCVersion;
import me.chancesd.pvpmanager.sdutils.utils.ReflectionUtil;
import me.chancesd.pvpmanager.setting.Conf;
import me.chancesd.pvpmanager.setting.Lang;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;

public final class CombatUtils {
    private static final DecimalFormat decimalFormat = new DecimalFormat();
    private static PlaceholderProcessor cachedPlaceholderProcessor;

    private CombatUtils() {
    }

    public static String formatTo2Digits(double value) {
        return decimalFormat.format(value);
    }

    public static boolean hasTimePassed(long toggleTime, int cooldown) {
        return CombatUtils.hasTimePassedMs(toggleTime, (long)cooldown * 1000L);
    }

    public static boolean hasTimePassedMs(long toggleTime, long cooldown) {
        return System.currentTimeMillis() - toggleTime >= cooldown;
    }

    public static int getTimeLeft(long startTime, int time) {
        return (int)(CombatUtils.getTimeLeftMs(startTime, (long)time * 1000L) / 1000L);
    }

    public static long getTimeLeftMs(long startTime, long time) {
        return startTime + time - System.currentTimeMillis();
    }

    public static void executeCommands(List<String> commands, Player player, String playerName, String victim) {
        if (commands.isEmpty()) {
            return;
        }
        for (String command : commands) {
            try {
                String preparedCommand = command.replace("{player}", playerName).replace("{victim}", victim).replace("{item}", CombatUtils.getItemDisplay(player.getItemInHand()));
                if (preparedCommand.toLowerCase().startsWith("!console")) {
                    ScheduleUtils.executeConsoleCommand(preparedCommand.substring(9));
                    continue;
                }
                if (preparedCommand.toLowerCase().startsWith("!player")) {
                    player.performCommand(preparedCommand.substring(8));
                    continue;
                }
                ScheduleUtils.executeConsoleCommand(preparedCommand);
            }
            catch (CommandException e) {
                Log.warning("Error executing command: \"" + command + "\" for player: " + playerName);
                Log.warning("This error comes from the command and it's respective plugin below:");
                Log.warning(e.getMessage(), e);
            }
        }
    }

    public static void executeCommands(List<String> commands, Player player, String playerName) {
        CombatUtils.executeCommands(commands, player, playerName, "");
    }

    private static String getItemDisplay(ItemStack item) {
        if (item.hasItemMeta()) {
            ItemMeta itemMeta = item.getItemMeta();
            if (itemMeta.hasDisplayName()) {
                return itemMeta.getDisplayName();
            }
            if (MCVersion.isAtLeast(MCVersion.V1_20_5) && itemMeta.hasItemName()) {
                return itemMeta.getItemName();
            }
        }
        return item.getType().name();
    }

    public static final boolean isPvP(EntityDamageByEntityEvent event) {
        TNTPrimed tnt;
        Entity tntAttacker;
        Entity shooter;
        ProjectileSource projSource;
        Entity attacker = event.getDamager();
        Entity defender = event.getEntity();
        if (!(defender instanceof Player)) {
            return false;
        }
        if (attacker instanceof Player) {
            return CombatUtils.isValidPvPAttack(attacker, defender);
        }
        if ((attacker instanceof Projectile || MCVersion.isAtLeast(MCVersion.V1_9) && attacker instanceof AreaEffectCloud) && (projSource = CombatUtils.getSource(attacker)) instanceof Player && CombatUtils.isValidPvPAttack(shooter = (Entity)projSource, defender)) {
            return CombatUtils.shouldCountDamage(event);
        }
        return attacker instanceof TNTPrimed && (tntAttacker = (tnt = (TNTPrimed)attacker).getSource()) instanceof Player && CombatUtils.isValidPvPAttack(tntAttacker, defender);
    }

    private static boolean isValidPvPAttack(Entity attacker, Entity defender) {
        return Conf.SELF_TAG.asBool() || !defender.equals((Object)attacker);
    }

    private static boolean shouldCountDamage(EntityDamageByEntityEvent event) {
        return !Conf.IGNORE_NO_DMG_HITS.asBool() || event.getDamage() != 0.0;
    }

    public static final boolean isPvP(EntityCombustByEntityEvent event) {
        Projectile projectile;
        ProjectileSource projSource;
        Entity attacker = event.getCombuster();
        Entity defender = event.getEntity();
        if (!(defender instanceof Player)) {
            return false;
        }
        if (attacker instanceof Player) {
            return true;
        }
        if (attacker instanceof Projectile && (projSource = (projectile = (Projectile)attacker).getShooter()) instanceof Player) {
            Entity shooter = (Entity)projSource;
            return CombatUtils.isValidPvPAttack(shooter, defender);
        }
        return false;
    }

    public static final boolean isNPC(Entity entity) {
        return entity.hasMetadata("NPC");
    }

    public static boolean canFly(Player p) {
        return p.isFlying() || p.getAllowFlight();
    }

    public static void checkGlide(Player p) {
        if (!p.isGliding()) {
            return;
        }
        Location playerLocation = p.getLocation();
        p.setGliding(false);
        ScheduleUtils.teleport((Entity)p, playerLocation);
        p.setFallDistance(-200.0f);
        if (!Conf.PUSHBACK_REMOVE_ELYTRA.asBool()) {
            return;
        }
        ItemStack chestplate = p.getInventory().getChestplate();
        if (chestplate == null || chestplate.getType() != Material.ELYTRA) {
            return;
        }
        p.getInventory().setChestplate(null);
        HashMap item = p.getInventory().addItem(new ItemStack[]{chestplate});
        if (!item.isEmpty()) {
            p.getWorld().dropItemNaturally(playerLocation, item.values().stream().findFirst().orElse(chestplate));
        }
    }

    public static void fakeItemStackDrop(Player player, ItemStack[] inventory) {
        Location playerLocation = player.getLocation();
        World playerWorld = player.getWorld();
        for (ItemStack itemstack : inventory) {
            if (itemstack == null || itemstack.getType().equals((Object)Material.AIR)) continue;
            playerWorld.dropItemNaturally(playerLocation, itemstack);
        }
    }

    public static boolean isOnline(@NotNull String name) {
        return Bukkit.getPlayer((String)name) != null;
    }

    public static boolean isOnlineWithFeedback(CommandSender sender, @NotNull String name) {
        if (!CombatUtils.isOnline(name)) {
            sender.sendMessage(Lang.ERROR_PLAYER_NOT_FOUND.msg(name));
            return false;
        }
        return true;
    }

    public static boolean isOnline(@NotNull UUID uuid) {
        return Bukkit.getPlayer((UUID)uuid) != null;
    }

    public static boolean isReal(@NotNull UUID id) {
        return Bukkit.getPlayer((UUID)id) != null;
    }

    public static boolean isWorldExcluded(String worldName) {
        return Conf.WORLD_EXCLUSIONS.asSet().contains(worldName);
    }

    public static boolean hasHarmfulPotion(AreaEffectCloud areaCloud) {
        if (MCVersion.isAtLeast(MCVersion.V1_20_2)) {
            PotionType basePotionType = areaCloud.getBasePotionType();
            if (basePotionType == null) {
                return false;
            }
            List potionTypes = basePotionType.getPotionEffects();
            return !potionTypes.isEmpty() && potionTypes.stream().anyMatch(p -> CombatUtils.isHarmfulPotion(p.getType()));
        }
        PotionEffectType potionEffectType = null;
        try {
            potionEffectType = (PotionEffectType)ReflectionUtil.invokeMethods(areaCloud, "getBasePotionData", "getType", "getEffectType");
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            Log.severe("Error getting potion type of lingering potion", e);
        }
        return potionEffectType != null && CombatUtils.isHarmfulPotion(potionEffectType);
    }

    public static boolean isHarmfulPotion(PotionEffectType type) {
        return Conf.HARMFUL_POTIONS.asSet().contains(type.getName());
    }

    public static boolean recursiveContainsCommand(String[] givenCommand, List<String> list) {
        boolean contains = false;
        for (int i = 0; i < givenCommand.length; ++i) {
            StringBuilder args = new StringBuilder(givenCommand[0]);
            for (int j = 1; j <= i; ++j) {
                args.append(" ").append(givenCommand[j]);
            }
            if (!list.contains(args.toString().toLowerCase())) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public static String truncateString(String text, int size) {
        return text.substring(0, Math.min(text.length(), size));
    }

    public static String processPlaceholders(Player player, String message) {
        if (message == null) {
            return message;
        }
        return ChatUtils.setPlaceholders(player, message, (p, msg) -> {
            if (cachedPlaceholderProcessor == null) {
                cachedPlaceholderProcessor = new PlaceholderProcessor(PvPManager.getInstance());
            }
            return cachedPlaceholderProcessor.replacePlaceholders((Player)p, (String)msg);
        });
    }

    private static ProjectileSource getSource(Entity entity) {
        if (entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            return projectile.getShooter();
        }
        return ((AreaEffectCloud)entity).getSource();
    }

    static {
        decimalFormat.setMaximumFractionDigits(2);
    }
}

