/*
 * Decompiled with CFR 0.152.
 */
package com.maybeizen.EasyTPA.commands;

import com.maybeizen.EasyTPA.EasyTPA;
import com.maybeizen.EasyTPA.utils.MessageUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TPDenyCommand
implements CommandExecutor {
    private final EasyTPA plugin;

    public TPDenyCommand(EasyTPA plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessage("player-only")));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("easytpa.tpdeny")) {
            MessageUtils.sendMessage(player, this.plugin.getConfigManager().getMessage("no-permission"));
            return true;
        }
        if (args.length > 0) {
            Player requester = this.plugin.getServer().getPlayer(args[0]);
            if (requester == null) {
                MessageUtils.sendMessage(player, this.plugin.getConfigManager().getMessage("player-not-found"));
                return true;
            }
            if (this.plugin.getTPAManager().denyRequestFrom(player, requester)) {
                MessageUtils.sendMessage(player, this.plugin.getConfigManager().getMessage("request-denied-target"), "player", requester.getName());
            }
        } else {
            String requesterName = this.plugin.getTPAManager().denyRequest(player);
            if (requesterName != null) {
                MessageUtils.sendMessage(player, this.plugin.getConfigManager().getMessage("request-denied-target"), "player", requesterName);
            } else {
                MessageUtils.sendMessage(player, this.plugin.getConfigManager().getMessage("no-pending-request"));
            }
        }
        return true;
    }
}

