/*
 * Decompiled with CFR 0.152.
 */
package com.maybeizen.EasyTPA.managers;

import com.maybeizen.EasyTPA.EasyTPA;
import com.maybeizen.EasyTPA.utils.MessageUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TPAManager {
    private final EasyTPA plugin;
    private final Map<UUID, UUID> tpaRequests;
    private final Map<UUID, Long> cooldowns;

    public TPAManager(EasyTPA plugin) {
        this.plugin = plugin;
        this.tpaRequests = new HashMap<UUID, UUID>();
        this.cooldowns = new HashMap<UUID, Long>();
    }

    public boolean sendRequest(final Player sender, final Player target) {
        final UUID senderUUID = sender.getUniqueId();
        final UUID targetUUID = target.getUniqueId();
        if (!this.plugin.getToggleManager().isTPEnabled(target) && !sender.hasPermission("easytpa.bypass")) {
            MessageUtils.sendMessage(sender, this.plugin.getConfigManager().getMessage("target-has-tp-disabled"), "player", target.getName());
            return false;
        }
        if (!sender.hasPermission("easytpa.cooldown.bypass") && this.isOnCooldown(sender)) {
            long remainingTime = (this.cooldowns.get(senderUUID) - System.currentTimeMillis()) / 1000L;
            MessageUtils.sendMessage(sender, this.plugin.getConfigManager().getMessage("cooldown"), "time", String.valueOf(remainingTime));
            return false;
        }
        if (this.tpaRequests.containsKey(targetUUID)) {
            MessageUtils.sendMessage(sender, this.plugin.getConfigManager().getMessage("already-has-request"));
            return false;
        }
        this.tpaRequests.put(targetUUID, senderUUID);
        if (!sender.hasPermission("easytpa.cooldown.bypass")) {
            this.setCooldown(sender);
        }
        new BukkitRunnable(){

            public void run() {
                if (TPAManager.this.tpaRequests.containsKey(targetUUID) && TPAManager.this.tpaRequests.get(targetUUID).equals(senderUUID)) {
                    TPAManager.this.tpaRequests.remove(targetUUID);
                    MessageUtils.sendMessage(sender, TPAManager.this.plugin.getConfigManager().getMessage("request-expired"));
                    if (target.isOnline()) {
                        MessageUtils.sendMessage(target, TPAManager.this.plugin.getConfigManager().getMessage("request-expired-target"));
                    }
                }
            }
        }.runTaskLater((Plugin)this.plugin, (long)this.plugin.getConfigManager().getRequestTimeout() * 20L);
        return true;
    }

    public boolean acceptRequest(Player target) {
        UUID targetUUID = target.getUniqueId();
        if (!this.tpaRequests.containsKey(targetUUID)) {
            MessageUtils.sendMessage(target, this.plugin.getConfigManager().getMessage("no-pending-request"));
            return false;
        }
        UUID senderUUID = this.tpaRequests.get(targetUUID);
        Player sender = this.plugin.getServer().getPlayer(senderUUID);
        if (sender == null || !sender.isOnline()) {
            MessageUtils.sendMessage(target, this.plugin.getConfigManager().getMessage("player-offline"));
            this.tpaRequests.remove(targetUUID);
            return false;
        }
        return this.performTeleport(sender, target);
    }

    public boolean acceptRequestFrom(Player target, Player requester) {
        UUID targetUUID = target.getUniqueId();
        UUID requesterUUID = requester.getUniqueId();
        if (!this.tpaRequests.containsKey(targetUUID) || !this.tpaRequests.get(targetUUID).equals(requesterUUID)) {
            MessageUtils.sendMessage(target, this.plugin.getConfigManager().getMessage("no-pending-request"));
            return false;
        }
        return this.performTeleport(requester, target);
    }

    private boolean performTeleport(Player sender, Player target) {
        sender.teleport(target.getLocation());
        MessageUtils.sendMessage(sender, this.plugin.getConfigManager().getMessage("request-accepted"), "player", target.getName());
        MessageUtils.sendMessage(target, this.plugin.getConfigManager().getMessage("request-accepted-target"), "player", sender.getName());
        MessageUtils.playTeleportEffect(sender);
        this.tpaRequests.remove(target.getUniqueId());
        return true;
    }

    public String denyRequest(Player target) {
        UUID targetUUID = target.getUniqueId();
        if (!this.tpaRequests.containsKey(targetUUID)) {
            return null;
        }
        UUID senderUUID = this.tpaRequests.get(targetUUID);
        Player sender = this.plugin.getServer().getPlayer(senderUUID);
        String senderName = sender != null ? sender.getName() : "Unknown";
        this.tpaRequests.remove(targetUUID);
        if (sender != null && sender.isOnline()) {
            MessageUtils.sendMessage(sender, this.plugin.getConfigManager().getMessage("request-denied"), "player", target.getName());
        }
        return senderName;
    }

    public boolean denyRequestFrom(Player target, Player requester) {
        UUID targetUUID = target.getUniqueId();
        UUID requesterUUID = requester.getUniqueId();
        if (!this.tpaRequests.containsKey(targetUUID) || !this.tpaRequests.get(targetUUID).equals(requesterUUID)) {
            MessageUtils.sendMessage(target, this.plugin.getConfigManager().getMessage("no-pending-request"));
            return false;
        }
        this.tpaRequests.remove(targetUUID);
        MessageUtils.sendMessage(requester, this.plugin.getConfigManager().getMessage("request-denied"), "player", target.getName());
        return true;
    }

    public void clearAllRequests() {
        this.tpaRequests.clear();
        this.cooldowns.clear();
    }

    private boolean isOnCooldown(Player player) {
        UUID uuid = player.getUniqueId();
        return this.cooldowns.containsKey(uuid) && this.cooldowns.get(uuid) > System.currentTimeMillis();
    }

    private void setCooldown(Player player) {
        UUID uuid = player.getUniqueId();
        this.cooldowns.put(uuid, System.currentTimeMillis() + (long)this.plugin.getConfigManager().getCooldown() * 1000L);
    }
}

