/*
 * Decompiled with CFR 0.152.
 */
package com.maybeizen.EasyTPA.managers;

import com.maybeizen.EasyTPA.EasyTPA;
import com.maybeizen.EasyTPA.utils.DatabaseManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

public class ToggleManager {
    private final EasyTPA plugin;
    private final HashMap<UUID, Boolean> toggleStates;
    private final DatabaseManager databaseManager;

    public ToggleManager(EasyTPA plugin) {
        this.plugin = plugin;
        this.toggleStates = new HashMap();
        this.databaseManager = plugin.getDatabaseManager();
        this.loadData();
    }

    private void loadData() {
        this.toggleStates.clear();
        this.databaseManager.reconnectIfNeeded();
        Map<UUID, Boolean> loadedStates = this.databaseManager.loadAllToggleStates();
        this.toggleStates.putAll(loadedStates);
    }

    public void saveData() {
        this.databaseManager.reconnectIfNeeded();
        for (Map.Entry<UUID, Boolean> entry : this.toggleStates.entrySet()) {
            this.databaseManager.saveToggleState(entry.getKey(), entry.getValue());
        }
    }

    public boolean isTPEnabled(Player player) {
        UUID uuid = player.getUniqueId();
        if (this.toggleStates.containsKey(uuid)) {
            return this.toggleStates.get(uuid);
        }
        boolean enabled = this.databaseManager.getToggleState(uuid);
        this.toggleStates.put(uuid, enabled);
        return enabled;
    }

    public boolean toggleTP(Player player) {
        UUID uuid = player.getUniqueId();
        boolean newState = !this.isTPEnabled(player);
        this.toggleStates.put(uuid, newState);
        this.databaseManager.saveToggleState(uuid, newState);
        return newState;
    }

    public void cleanup() {
        this.saveData();
        this.toggleStates.clear();
    }

    public void reload() {
        this.loadData();
    }
}

