/*
 * Decompiled with CFR 0.152.
 */
package com.maybeizen.EasyTPA;

import com.maybeizen.EasyTPA.commands.EasyTPACommand;
import com.maybeizen.EasyTPA.commands.TPACommand;
import com.maybeizen.EasyTPA.commands.TPAcceptCommand;
import com.maybeizen.EasyTPA.commands.TPCancelCommand;
import com.maybeizen.EasyTPA.commands.TPDenyCommand;
import com.maybeizen.EasyTPA.commands.TPListCommand;
import com.maybeizen.EasyTPA.commands.TPToggleCommand;
import com.maybeizen.EasyTPA.managers.CooldownManager;
import com.maybeizen.EasyTPA.managers.TPAManager;
import com.maybeizen.EasyTPA.managers.ToggleManager;
import com.maybeizen.EasyTPA.utils.ConfigManager;
import com.maybeizen.EasyTPA.utils.DatabaseManager;
import com.maybeizen.EasyTPA.utils.MessageUtils;
import com.maybeizen.EasyTPA.utils.VersionAdapter;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class EasyTPA
extends JavaPlugin {
    private ConfigManager configManager;
    private DatabaseManager databaseManager;
    private TPAManager tpaManager;
    private CooldownManager cooldownManager;
    private ToggleManager toggleManager;

    public void onEnable() {
        this.saveDefaultConfig();
        this.configManager = ConfigManager.getInstance(this);
        this.databaseManager = new DatabaseManager(this);
        MessageUtils.initialize(this);
        this.tpaManager = new TPAManager(this);
        this.cooldownManager = new CooldownManager(this.configManager.getCooldown());
        this.toggleManager = new ToggleManager(this);
        this.getCommand("tpa").setExecutor((CommandExecutor)new TPACommand(this));
        this.getCommand("tpaccept").setExecutor((CommandExecutor)new TPAcceptCommand(this));
        this.getCommand("tpdeny").setExecutor((CommandExecutor)new TPDenyCommand(this));
        this.getCommand("tptoggle").setExecutor((CommandExecutor)new TPToggleCommand(this));
        this.getCommand("tpcancel").setExecutor((CommandExecutor)new TPCancelCommand(this));
        this.getCommand("tplist").setExecutor((CommandExecutor)new TPListCommand(this));
        EasyTPACommand adminCommand = new EasyTPACommand(this);
        this.getCommand("easytpa").setExecutor((CommandExecutor)adminCommand);
        this.getCommand("easytpa").setTabCompleter((TabCompleter)adminCommand);
        this.startCleanupTask();
        Bukkit.getLogger().info("EasyTPA has been enabled!");
        Bukkit.getLogger().info("Running on server version: " + VersionAdapter.getServerVersion());
    }

    public void onDisable() {
        if (this.tpaManager != null) {
            this.tpaManager.clearAllRequests();
        }
        if (this.toggleManager != null) {
            this.toggleManager.cleanup();
        }
        if (this.databaseManager != null) {
            this.databaseManager.closeConnection();
        }
        Bukkit.getLogger().info("EasyTPA has been disabled!");
    }

    public void reloadConfiguration() {
        if (this.toggleManager != null) {
            this.toggleManager.saveData();
        }
        this.reloadConfig();
        this.configManager.reloadConfig();
        this.cooldownManager = new CooldownManager(this.configManager.getCooldown());
        if (this.toggleManager != null) {
            this.toggleManager.reload();
        } else {
            this.toggleManager = new ToggleManager(this);
        }
        MessageUtils.initialize(this);
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public TPAManager getTPAManager() {
        return this.tpaManager;
    }

    public CooldownManager getCooldownManager() {
        return this.cooldownManager;
    }

    public ToggleManager getToggleManager() {
        return this.toggleManager;
    }

    private void startCleanupTask() {
        new BukkitRunnable(){

            public void run() {
                if (EasyTPA.this.cooldownManager != null) {
                    int before = EasyTPA.this.cooldownManager.getActiveCooldownCount();
                    EasyTPA.this.cooldownManager.cleanupExpired();
                    int after = EasyTPA.this.cooldownManager.getActiveCooldownCount();
                    if (before > after) {
                        EasyTPA.this.getLogger().fine("Cleaned up " + (before - after) + " expired cooldowns");
                    }
                }
            }
        }.runTaskTimer((Plugin)this, 6000L, 6000L);
    }
}

