/*
 * Decompiled with CFR 0.152.
 */
package com.maybeizen.EasyTPA.commands;

import com.maybeizen.EasyTPA.EasyTPA;
import com.maybeizen.EasyTPA.utils.MessageUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TPACommand
implements CommandExecutor {
    private final EasyTPA plugin;

    public TPACommand(EasyTPA plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessage("player-only")));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("easytpa.tpa")) {
            MessageUtils.sendMessage(player, this.plugin.getConfigManager().getMessage("no-permission"));
            return true;
        }
        if (args.length != 1) {
            MessageUtils.sendMessage(player, this.plugin.getConfigManager().getMessage("tpa-usage"));
            return true;
        }
        Player target = this.plugin.getServer().getPlayer(args[0]);
        if (target == null) {
            MessageUtils.sendMessage(player, this.plugin.getConfigManager().getMessage("player-not-found"));
            return true;
        }
        if (target.equals((Object)player)) {
            MessageUtils.sendMessage(player, this.plugin.getConfigManager().getMessage("cannot-teleport-self"));
            return true;
        }
        if (this.plugin.getTPAManager().sendRequest(player, target)) {
            MessageUtils.sendMessage(player, this.plugin.getConfigManager().getMessage("request-sent", player, "player", target.getName()));
            MessageUtils.sendTeleportRequest(player, target);
        }
        return true;
    }
}

