/*
 * Decompiled with CFR 0.152.
 */
package com.maybeizen.EasyTPA.commands;

import com.maybeizen.EasyTPA.EasyTPA;
import com.maybeizen.EasyTPA.managers.TPARequest;
import com.maybeizen.EasyTPA.utils.MessageUtils;
import java.util.List;
import java.util.UUID;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TPListCommand
implements CommandExecutor {
    private final EasyTPA plugin;

    public TPListCommand(EasyTPA plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessage("player-only")));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("easytpa.tpa")) {
            MessageUtils.sendMessage(player, this.plugin.getConfigManager().getMessage("no-permission"));
            return true;
        }
        UUID playerUUID = player.getUniqueId();
        List<TPARequest> requests = this.plugin.getTPAManager().getRequestsForPlayer(playerUUID);
        if (requests.isEmpty()) {
            MessageUtils.sendMessage(player, this.plugin.getConfigManager().getMessage("no-pending-requests"));
            return true;
        }
        MessageUtils.sendMessage(player, this.plugin.getConfigManager().getMessage("request-list-header"));
        for (TPARequest request : requests) {
            Player targetPlayer;
            if (request.getTargetUUID().equals(playerUUID)) {
                Player senderPlayer = this.plugin.getServer().getPlayer(request.getSenderUUID());
                if (senderPlayer == null || !senderPlayer.isOnline()) continue;
                MessageUtils.sendMessage(player, this.plugin.getConfigManager().getMessage("request-list-received", "player", senderPlayer.getName()));
                continue;
            }
            if (!request.isFrom(playerUUID) || (targetPlayer = this.plugin.getServer().getPlayer(request.getTargetUUID())) == null || !targetPlayer.isOnline()) continue;
            MessageUtils.sendMessage(player, this.plugin.getConfigManager().getMessage("request-list-sent", "player", targetPlayer.getName()));
        }
        return true;
    }
}

