/*
 * Decompiled with CFR 0.152.
 */
package com.maybeizen.EasyTPA.managers;

import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class CooldownManager {
    private final ConcurrentHashMap<UUID, Long> cooldowns = new ConcurrentHashMap();
    private final long cooldownTime;

    public CooldownManager(long cooldownSeconds) {
        this.cooldownTime = cooldownSeconds * 1000L;
    }

    public boolean hasCooldown(UUID playerId) {
        Long expiryTime = this.cooldowns.get(playerId);
        if (expiryTime == null) {
            return false;
        }
        long timeLeft = expiryTime - System.currentTimeMillis();
        if (timeLeft <= 0L) {
            this.cooldowns.remove(playerId);
            return false;
        }
        return true;
    }

    public long getRemainingTime(UUID playerId) {
        Long expiryTime = this.cooldowns.get(playerId);
        if (expiryTime == null) {
            return 0L;
        }
        long remaining = expiryTime - System.currentTimeMillis();
        return remaining > 0L ? remaining : 0L;
    }

    public void setCooldown(UUID playerId) {
        this.cooldowns.put(playerId, System.currentTimeMillis() + this.cooldownTime);
    }

    public String getRemainingTimeString(UUID playerId) {
        long timeLeft = this.getRemainingTime(playerId) / 1000L;
        return timeLeft + " seconds";
    }

    public void cleanupExpired() {
        long currentTime = System.currentTimeMillis();
        Iterator<Map.Entry<UUID, Long>> iterator = this.cooldowns.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, Long> entry = iterator.next();
            if (entry.getValue() > currentTime) continue;
            iterator.remove();
        }
    }

    public int getActiveCooldownCount() {
        return this.cooldowns.size();
    }
}

