/*
 * Decompiled with CFR 0.152.
 */
package com.maybeizen.EasyTPA.managers;

import com.maybeizen.EasyTPA.EasyTPA;
import com.maybeizen.EasyTPA.managers.TPARequest;
import com.maybeizen.EasyTPA.utils.MessageUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TPAManager {
    private final EasyTPA plugin;
    private final Map<UUID, TPARequest> tpaRequests;
    private final Map<UUID, BukkitRunnable> pendingTeleports;

    public TPAManager(EasyTPA plugin) {
        this.plugin = plugin;
        this.tpaRequests = new ConcurrentHashMap<UUID, TPARequest>();
        this.pendingTeleports = new ConcurrentHashMap<UUID, BukkitRunnable>();
    }

    public boolean sendRequest(Player sender, Player target) {
        final UUID senderUUID = sender.getUniqueId();
        UUID targetUUID = target.getUniqueId();
        if (!this.plugin.getToggleManager().isTPEnabled(target) && !sender.hasPermission("easytpa.bypass")) {
            MessageUtils.sendMessage(sender, this.plugin.getConfigManager().getMessage("target-has-tp-disabled"), "player", target.getName());
            return false;
        }
        if (!sender.hasPermission("easytpa.cooldown.bypass") && this.plugin.getCooldownManager().hasCooldown(senderUUID)) {
            long remainingTime = this.plugin.getCooldownManager().getRemainingTime(senderUUID) / 1000L;
            MessageUtils.sendMessage(sender, this.plugin.getConfigManager().getMessage("cooldown"), "time", String.valueOf(remainingTime));
            return false;
        }
        if (this.tpaRequests.containsKey(targetUUID)) {
            MessageUtils.sendMessage(sender, this.plugin.getConfigManager().getMessage("already-has-request"));
            return false;
        }
        TPARequest request = new TPARequest(senderUUID, targetUUID, target.getLocation());
        this.tpaRequests.put(targetUUID, request);
        if (!sender.hasPermission("easytpa.cooldown.bypass")) {
            this.plugin.getCooldownManager().setCooldown(senderUUID);
        }
        final UUID finalTargetUUID = targetUUID;
        new BukkitRunnable(){

            public void run() {
                TPARequest request = TPAManager.this.tpaRequests.get(finalTargetUUID);
                if (request != null && request.isFrom(senderUUID)) {
                    TPAManager.this.tpaRequests.remove(finalTargetUUID);
                    Player senderPlayer = TPAManager.this.plugin.getServer().getPlayer(senderUUID);
                    Player targetPlayer = TPAManager.this.plugin.getServer().getPlayer(finalTargetUUID);
                    if (senderPlayer != null && senderPlayer.isOnline()) {
                        MessageUtils.sendMessage(senderPlayer, TPAManager.this.plugin.getConfigManager().getMessage("request-expired"));
                    }
                    if (targetPlayer != null && targetPlayer.isOnline()) {
                        MessageUtils.sendMessage(targetPlayer, TPAManager.this.plugin.getConfigManager().getMessage("request-expired-target"));
                    }
                }
            }
        }.runTaskLater((Plugin)this.plugin, (long)this.plugin.getConfigManager().getRequestTimeout() * 20L);
        return true;
    }

    public boolean acceptRequest(Player target) {
        UUID targetUUID = target.getUniqueId();
        TPARequest request = this.tpaRequests.get(targetUUID);
        if (request == null) {
            MessageUtils.sendMessage(target, this.plugin.getConfigManager().getMessage("no-pending-request"));
            return false;
        }
        Player sender = this.plugin.getServer().getPlayer(request.getSenderUUID());
        if (sender == null || !sender.isOnline()) {
            MessageUtils.sendMessage(target, this.plugin.getConfigManager().getMessage("player-offline"));
            this.tpaRequests.remove(targetUUID);
            return false;
        }
        return this.performTeleport(sender, request.getTargetLocation(), target);
    }

    public boolean acceptRequestFrom(Player target, Player requester) {
        UUID targetUUID = target.getUniqueId();
        UUID requesterUUID = requester.getUniqueId();
        TPARequest request = this.tpaRequests.get(targetUUID);
        if (request == null || !request.isFrom(requesterUUID)) {
            MessageUtils.sendMessage(target, this.plugin.getConfigManager().getMessage("no-pending-request"));
            return false;
        }
        return this.performTeleport(requester, request.getTargetLocation(), target);
    }

    private boolean performTeleport(final Player sender, final Location targetLocation, final Player target) {
        final UUID senderUUID = sender.getUniqueId();
        if (this.pendingTeleports.containsKey(senderUUID)) {
            MessageUtils.sendMessage(sender, this.plugin.getConfigManager().getMessage("teleport-already-pending"));
            return false;
        }
        if (!this.isSafeLocation(targetLocation)) {
            MessageUtils.sendMessage(sender, this.plugin.getConfigManager().getMessage("teleport-unsafe", "player", target.getName()));
            MessageUtils.sendMessage(target, this.plugin.getConfigManager().getMessage("teleport-unsafe-target", "player", sender.getName()));
            this.tpaRequests.remove(target.getUniqueId());
            return false;
        }
        final int delay = this.plugin.getConfigManager().getTeleportDelay();
        this.tpaRequests.remove(target.getUniqueId());
        if (delay <= 0 || sender.hasPermission("easytpa.delay.bypass")) {
            this.executeTeleport(sender, targetLocation, target);
            return true;
        }
        MessageUtils.sendMessage(sender, this.plugin.getConfigManager().getMessage("teleport-starting", "time", String.valueOf(delay)));
        MessageUtils.sendMessage(target, this.plugin.getConfigManager().getMessage("teleport-starting-target", "player", sender.getName(), "time", String.valueOf(delay)));
        final Location startLocation = sender.getLocation().clone();
        BukkitRunnable teleportTask = new BukkitRunnable(){
            private int countdown;
            {
                this.countdown = delay;
            }

            public void run() {
                if (!sender.isOnline() || !target.isOnline()) {
                    TPAManager.this.cancelTeleport(senderUUID);
                    return;
                }
                if (!sender.getLocation().getWorld().equals((Object)startLocation.getWorld()) || sender.getLocation().distanceSquared(startLocation) > 1.0) {
                    TPAManager.this.cancelTeleport(senderUUID);
                    MessageUtils.sendMessage(sender, TPAManager.this.plugin.getConfigManager().getMessage("teleport-cancelled-moved"));
                    MessageUtils.sendMessage(target, TPAManager.this.plugin.getConfigManager().getMessage("teleport-cancelled-moved-target", "player", sender.getName()));
                    return;
                }
                --this.countdown;
                if (this.countdown <= 0) {
                    TPAManager.this.executeTeleport(sender, targetLocation, target);
                    TPAManager.this.pendingTeleports.remove(senderUUID);
                    this.cancel();
                } else if (this.countdown <= 3) {
                    MessageUtils.sendMessage(sender, TPAManager.this.plugin.getConfigManager().getMessage("teleport-countdown", "time", String.valueOf(this.countdown)));
                }
            }
        };
        this.pendingTeleports.put(senderUUID, teleportTask);
        teleportTask.runTaskTimer((Plugin)this.plugin, 0L, 20L);
        return true;
    }

    private void executeTeleport(Player sender, Location targetLocation, Player target) {
        if (!this.isSafeLocation(targetLocation)) {
            MessageUtils.sendMessage(sender, this.plugin.getConfigManager().getMessage("teleport-unsafe", "player", target.getName()));
            MessageUtils.sendMessage(target, this.plugin.getConfigManager().getMessage("teleport-unsafe-target", "player", sender.getName()));
            return;
        }
        sender.teleport(targetLocation);
        MessageUtils.sendMessage(sender, this.plugin.getConfigManager().getMessage("request-accepted"), "player", target.getName());
        MessageUtils.sendMessage(target, this.plugin.getConfigManager().getMessage("request-accepted-target"), "player", sender.getName());
        MessageUtils.playTeleportEffect(sender);
    }

    public boolean cancelTeleport(UUID senderUUID) {
        BukkitRunnable task = this.pendingTeleports.remove(senderUUID);
        if (task != null) {
            task.cancel();
            return true;
        }
        return false;
    }

    private boolean isSafeLocation(Location location) {
        if (location == null) {
            return false;
        }
        Block blockAtFeet = location.getBlock();
        Block blockAtHead = location.clone().add(0.0, 1.0, 0.0).getBlock();
        if (blockAtFeet.getType().isSolid() || blockAtHead.getType().isSolid()) {
            return false;
        }
        Block blockBelow = location.clone().subtract(0.0, 1.0, 0.0).getBlock();
        return !blockBelow.getType().isAir();
    }

    public TPARequest getRequestBySender(UUID senderUUID) {
        for (TPARequest request : this.tpaRequests.values()) {
            if (!request.isFrom(senderUUID)) continue;
            return request;
        }
        return null;
    }

    public boolean cancelRequestBySender(UUID senderUUID) {
        TPARequest request = this.getRequestBySender(senderUUID);
        if (request != null) {
            this.tpaRequests.remove(request.getTargetUUID());
            return true;
        }
        return false;
    }

    public String denyRequest(Player target) {
        UUID targetUUID = target.getUniqueId();
        TPARequest request = this.tpaRequests.get(targetUUID);
        if (request == null) {
            return null;
        }
        Player sender = this.plugin.getServer().getPlayer(request.getSenderUUID());
        String senderName = sender != null ? sender.getName() : "Unknown";
        this.tpaRequests.remove(targetUUID);
        if (sender != null && sender.isOnline()) {
            MessageUtils.sendMessage(sender, this.plugin.getConfigManager().getMessage("request-denied"), "player", target.getName());
        }
        return senderName;
    }

    public boolean denyRequestFrom(Player target, Player requester) {
        UUID targetUUID = target.getUniqueId();
        UUID requesterUUID = requester.getUniqueId();
        TPARequest request = this.tpaRequests.get(targetUUID);
        if (request == null || !request.isFrom(requesterUUID)) {
            MessageUtils.sendMessage(target, this.plugin.getConfigManager().getMessage("no-pending-request"));
            return false;
        }
        this.tpaRequests.remove(targetUUID);
        MessageUtils.sendMessage(requester, this.plugin.getConfigManager().getMessage("request-denied"), "player", target.getName());
        return true;
    }

    public void clearAllRequests() {
        this.tpaRequests.clear();
        for (BukkitRunnable task : this.pendingTeleports.values()) {
            task.cancel();
        }
        this.pendingTeleports.clear();
    }

    public List<TPARequest> getRequestsForPlayer(UUID playerUUID) {
        ArrayList<TPARequest> requests = new ArrayList<TPARequest>();
        for (TPARequest request : this.tpaRequests.values()) {
            if (!request.getTargetUUID().equals(playerUUID) && !request.isFrom(playerUUID)) continue;
            requests.add(request);
        }
        return requests;
    }
}

