/*
 * Decompiled with CFR 0.152.
 */
package com.maybeizen.EasyTPA.utils;

import com.maybeizen.EasyTPA.EasyTPA;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;

public class DatabaseManager {
    private final EasyTPA plugin;
    private Connection connection;
    private final String dbFile;
    private final Object dbLock = new Object();
    private static final String CREATE_TOGGLE_TABLE = "CREATE TABLE IF NOT EXISTS toggle_states (uuid VARCHAR(36) PRIMARY KEY, enabled BOOLEAN NOT NULL DEFAULT 1)";
    private static final String INSERT_TOGGLE = "INSERT OR REPLACE INTO toggle_states (uuid, enabled) VALUES (?, ?)";
    private static final String SELECT_ALL_TOGGLES = "SELECT uuid, enabled FROM toggle_states";
    private static final String SELECT_TOGGLE = "SELECT enabled FROM toggle_states WHERE uuid = ?";

    public DatabaseManager(EasyTPA plugin) {
        this.plugin = plugin;
        this.dbFile = new File(plugin.getDataFolder(), "easytpa.db").getAbsolutePath();
        this.initialize();
    }

    private void initialize() {
        try {
            if (!this.plugin.getDataFolder().exists()) {
                this.plugin.getDataFolder().mkdirs();
            }
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.dbFile);
            try (Statement statement = this.connection.createStatement();){
                statement.execute(CREATE_TOGGLE_TABLE);
            }
            this.plugin.getLogger().info("Database connection established successfully");
        }
        catch (ClassNotFoundException e) {
            this.plugin.getLogger().log(Level.SEVERE, "SQLite JDBC driver not found", e);
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not connect to SQLite database", e);
        }
    }

    public void closeConnection() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
                this.plugin.getLogger().info("Database connection closed");
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.WARNING, "Error closing database connection", e);
        }
    }

    public void saveToggleState(UUID uuid, boolean enabled) {
        this.saveToggleStateAsync(uuid, enabled, null);
    }

    public void saveToggleStateAsync(UUID uuid, boolean enabled, Runnable callback) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            Object object = this.dbLock;
            synchronized (object) {
                if (this.connection == null) {
                    this.plugin.getLogger().warning("Cannot save toggle state: database connection is null");
                    if (callback != null) {
                        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, callback);
                    }
                    return;
                }
                try (PreparedStatement statement = this.connection.prepareStatement(INSERT_TOGGLE);){
                    statement.setString(1, uuid.toString());
                    statement.setBoolean(2, enabled);
                    statement.executeUpdate();
                }
                catch (SQLException e) {
                    this.plugin.getLogger().log(Level.WARNING, "Error saving toggle state for " + String.valueOf(uuid), e);
                }
                finally {
                    if (callback != null) {
                        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, callback);
                    }
                }
            }
        });
    }

    public Map<UUID, Boolean> loadAllToggleStates() {
        return this.loadAllToggleStatesAsync(null);
    }

    public Map<UUID, Boolean> loadAllToggleStatesAsync(Consumer<Map<UUID, Boolean>> callback) {
        HashMap<UUID, Boolean> toggleStates = new HashMap<UUID, Boolean>();
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            HashMap<UUID, Boolean> loadedStates = new HashMap<UUID, Boolean>();
            Object object = this.dbLock;
            synchronized (object) {
                if (this.connection == null) {
                    this.plugin.getLogger().warning("Cannot load toggle states: database connection is null");
                    if (callback != null) {
                        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> callback.accept(loadedStates));
                    }
                    return;
                }
                try (Statement statement = this.connection.createStatement();
                     ResultSet resultSet = statement.executeQuery(SELECT_ALL_TOGGLES);){
                    while (resultSet.next()) {
                        try {
                            UUID uuid = UUID.fromString(resultSet.getString("uuid"));
                            boolean enabled = resultSet.getBoolean("enabled");
                            loadedStates.put(uuid, enabled);
                        }
                        catch (IllegalArgumentException e) {
                            this.plugin.getLogger().warning("Invalid UUID in database: " + resultSet.getString("uuid"));
                        }
                    }
                }
                catch (SQLException e) {
                    this.plugin.getLogger().log(Level.WARNING, "Error loading toggle states", e);
                }
            }
            if (callback != null) {
                HashMap finalStates = new HashMap(loadedStates);
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> callback.accept(finalStates));
            }
        });
        return toggleStates;
    }

    public boolean getToggleState(UUID uuid) {
        return this.getToggleStateAsync(uuid, null);
    }

    public boolean getToggleStateAsync(UUID uuid, Consumer<Boolean> callback) {
        boolean[] result = new boolean[]{true};
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            boolean queryResult = true;
            Object object = this.dbLock;
            synchronized (object) {
                if (this.connection == null) {
                    this.plugin.getLogger().warning("Cannot get toggle state: database connection is null");
                    if (callback != null) {
                        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> callback.accept(true));
                    }
                    return;
                }
                try (PreparedStatement statement = this.connection.prepareStatement(SELECT_TOGGLE);){
                    statement.setString(1, uuid.toString());
                    try (ResultSet resultSet = statement.executeQuery();){
                        if (resultSet.next()) {
                            queryResult = resultSet.getBoolean("enabled");
                        }
                    }
                }
                catch (SQLException e) {
                    this.plugin.getLogger().log(Level.WARNING, "Error getting toggle state for " + String.valueOf(uuid), e);
                }
            }
            if (callback != null) {
                boolean finalResult = queryResult;
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> callback.accept(finalResult));
            }
            result[0] = queryResult;
        });
        return result[0];
    }

    public boolean isConnectionValid() {
        try {
            return this.connection != null && !this.connection.isClosed();
        }
        catch (SQLException e) {
            return false;
        }
    }

    public void reconnectIfNeeded() {
        try {
            if (this.connection == null || this.connection.isClosed()) {
                this.initialize();
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.WARNING, "Error checking database connection", e);
            this.initialize();
        }
    }
}

