/*
 * Decompiled with CFR 0.152.
 */
package com.maybeizen.EasyTPA.utils;

import com.maybeizen.EasyTPA.EasyTPA;
import com.maybeizen.EasyTPA.utils.VersionAdapter;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.StyleSetter;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.entity.Player;

public class MessageUtils {
    private static EasyTPA plugin;
    private static final LegacyComponentSerializer LEGACY_SERIALIZER;
    private static final MiniMessage MINI_MESSAGE;

    public static void initialize(EasyTPA pluginInstance) {
        plugin = pluginInstance;
    }

    private static Component getPrefix() {
        String prefix = plugin.getConfigManager().getMessage("prefix");
        return MessageUtils.parseText(prefix);
    }

    private static Component parseText(String message) {
        if (message.contains("<") && message.contains(">")) {
            return MINI_MESSAGE.deserialize((Object)message);
        }
        return LEGACY_SERIALIZER.deserialize(message);
    }

    public static Component formatMessage(String message) {
        return MessageUtils.getPrefix().append(MessageUtils.parseText(message));
    }

    public static Component formatMessage(String message, Player player) {
        return MessageUtils.getPrefix().append(MessageUtils.parseText(message));
    }

    public static Component formatMessage(String message, String ... placeholders) {
        if (placeholders.length % 2 != 0) {
            throw new IllegalArgumentException("Placeholders must be in pairs of key-value");
        }
        HashMap<String, String> replacements = new HashMap<String, String>();
        for (int i = 0; i < placeholders.length; i += 2) {
            replacements.put(placeholders[i], placeholders[i + 1]);
        }
        String formattedMessage = message;
        for (Map.Entry entry : replacements.entrySet()) {
            formattedMessage = formattedMessage.replace("%" + (String)entry.getKey() + "%", (CharSequence)entry.getValue());
        }
        return MessageUtils.getPrefix().append(MessageUtils.parseText(formattedMessage));
    }

    public static Component formatMessage(String message, Player player, String ... placeholders) {
        if (placeholders.length % 2 != 0) {
            throw new IllegalArgumentException("Placeholders must be in pairs of key-value");
        }
        HashMap<String, String> replacements = new HashMap<String, String>();
        for (int i = 0; i < placeholders.length; i += 2) {
            replacements.put(placeholders[i], placeholders[i + 1]);
        }
        String formattedMessage = message;
        for (Map.Entry entry : replacements.entrySet()) {
            formattedMessage = formattedMessage.replace("%" + (String)entry.getKey() + "%", (CharSequence)entry.getValue());
        }
        return MessageUtils.getPrefix().append(MessageUtils.parseText(formattedMessage));
    }

    public static void sendMessage(Player player, String message) {
        player.sendMessage(MessageUtils.formatMessage(message, player));
    }

    public static void sendMessage(Player player, String message, String ... placeholders) {
        player.sendMessage(MessageUtils.formatMessage(message, player, placeholders));
    }

    public static void sendTeleportRequest(Player sender, Player target) {
        String requestMessage = plugin.getConfigManager().getMessage("request-received", target, "player", sender.getName());
        Component message = MessageUtils.getPrefix().append(MessageUtils.parseText(requestMessage)).append(Component.newline());
        String acceptButtonText = plugin.getConfigManager().getMessage("chat-button-accept", target);
        String acceptHoverText = plugin.getConfigManager().getMessage("hover-text-accept", target);
        StyleSetter accept = MessageUtils.parseText(acceptButtonText).clickEvent(ClickEvent.runCommand("/tpaccept " + sender.getName())).hoverEvent(HoverEvent.showText(MessageUtils.parseText(acceptHoverText)));
        String denyButtonText = plugin.getConfigManager().getMessage("chat-button-deny", target);
        String denyHoverText = plugin.getConfigManager().getMessage("hover-text-deny", target);
        StyleSetter deny = MessageUtils.parseText(denyButtonText).clickEvent(ClickEvent.runCommand("/tpdeny " + sender.getName())).hoverEvent(HoverEvent.showText(MessageUtils.parseText(denyHoverText)));
        target.sendMessage(message.append((Component)accept).append(Component.space()).append((Component)deny));
        if (plugin.getConfigManager().getSoundsEnabled()) {
            VersionAdapter.playRequestSound(target);
        }
    }

    public static void playTeleportEffect(Player player) {
        if (plugin != null && plugin.getConfigManager().getSoundsEnabled()) {
            VersionAdapter.playTeleportSound(player);
        }
    }

    static {
        LEGACY_SERIALIZER = LegacyComponentSerializer.builder().character('&').hexColors().build();
        MINI_MESSAGE = MiniMessage.miniMessage();
    }
}

