/*
 * Decompiled with CFR 0.152.
 */
package net.persuasiveviksy.msextras.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.persuasiveviksy.msextras.client.model.ModelSwordBeam;
import net.persuasiveviksy.msextras.entity.ZenithSwordbeamEntity;

public class ZenithSwordbeamRenderer
extends EntityRenderer<ZenithSwordbeamEntity> {
    private static final ResourceLocation texture = ResourceLocation.parse((String)"ms_extras:textures/entities/swordbeam.png");
    private final ModelSwordBeam model;

    public ZenithSwordbeamRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new ModelSwordBeam(context.bakeLayer(ModelSwordBeam.LAYER_LOCATION));
    }

    public void render(ZenithSwordbeamEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        VertexConsumer vb = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(entityIn)));
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.yRotO, (float)entityIn.getYRot()) - 90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f + Mth.lerp((float)partialTicks, (float)entityIn.xRotO, (float)entityIn.getXRot())));
        this.model.renderToBuffer(poseStack, vb, packedLightIn, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        super.render((Entity)entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(ZenithSwordbeamEntity entity) {
        return texture;
    }
}

