/*
 * Decompiled with CFR 0.152.
 */
package one.pkg.pinperlauncher;

public class HintAnimator {
    private final String[] hints;
    private int current = 0;
    private float opacity = 1.0f;
    private long timer = 0L;
    private boolean fadingOut = true;
    private int dotCount = 0;
    private long dotTimer = 0L;
    private float externalProgress = -1.0f;
    private int forcedStage = -1;
    private int lastStage = -1;
    private static final float STAGE_1_START = 0.33f;
    private static final float STAGE_2_START = 0.75f;

    public HintAnimator(String[] hints) {
        this.hints = hints;
    }

    public void setProgress(float progress) {
        this.externalProgress = progress;
    }

    public void setHintStage(int stage) {
        if (stage >= 0 && stage < this.hints.length && this.current != stage) {
            this.forcedStage = stage;
            this.current = stage;
            this.lastStage = stage;
        }
    }

    public void update(long delta) {
        this.timer += delta;
        this.dotTimer += delta;
        if (this.dotTimer > 300L) {
            this.dotCount = (this.dotCount + 1) % 4;
            this.dotTimer = 0L;
        }
        if (this.externalProgress >= 0.0f) {
            if (this.forcedStage >= 0) {
                int newStage = this.getStageFromProgress(this.externalProgress);
                if (newStage != this.lastStage) {
                    this.current = newStage;
                    this.lastStage = newStage;
                }
            } else {
                int newStage = this.getStageFromProgress(this.externalProgress);
                if (newStage != this.current) {
                    this.current = newStage;
                    this.lastStage = newStage;
                }
            }
            this.opacity = 1.0f;
            return;
        }
        if (this.timer > 3000L) {
            this.timer = 0L;
            boolean bl = this.fadingOut = !this.fadingOut;
            if (!this.fadingOut) {
                this.current = (this.current + 1) % this.hints.length;
            }
        }
        this.opacity = this.fadingOut ? (this.opacity -= (float)delta / 1000.0f) : (this.opacity += (float)delta / 1000.0f);
        this.opacity = Math.max(0.0f, Math.min(1.0f, this.opacity));
    }

    private int getStageFromProgress(float progress) {
        if (progress < 0.33f) {
            return 0;
        }
        if (progress < 0.75f) {
            return 1;
        }
        return 2;
    }

    public String getCurrentHint() {
        String base = this.hints[this.current];
        return base + ".".repeat(this.dotCount);
    }

    public float getOpacity() {
        if (this.externalProgress >= 0.0f) {
            return 1.0f;
        }
        return this.opacity;
    }
}

