/*
 * Decompiled with CFR 0.152.
 */
package one.pkg.pinperlauncher;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.neoforged.fml.earlydisplay.SimpleBufferBuilder;
import net.neoforged.fml.loading.FMLConfig;
import net.neoforged.fml.loading.ImmediateWindowHandler;
import net.neoforged.fml.loading.progress.ProgressMeter;
import net.neoforged.fml.loading.progress.StartupNotificationManager;
import net.neoforged.neoforgespi.earlywindow.ImmediateWindowProvider;
import one.pkg.pinperlauncher.PinperRenderer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinperEarlyWindow
implements ImmediateWindowProvider {
    static final Logger logger = LoggerFactory.getLogger(PinperEarlyWindow.class);
    private static final int[][] GL_VERSIONS = new int[][]{{4, 6}, {4, 5}, {4, 4}, {4, 3}, {4, 2}, {4, 1}, {4, 0}, {3, 3}, {3, 2}};
    private static final float[] STAGE_STARTS = new float[]{0.0f, 0.08f, 0.18f, 0.3f, 0.45f, 0.65f, 0.85f};
    private static final float[] STAGE_ENDS = new float[]{0.08f, 0.18f, 0.3f, 0.45f, 0.65f, 0.85f, 0.999f};
    private final int width = 1100;
    private final int height = 600;
    private final Object frameLock = new Object();
    private long window;
    private PinperRenderer renderer;
    private ScheduledExecutorService scheduler;
    private volatile boolean active = true;
    private volatile boolean handedOff = false;
    private volatile boolean renderThreadInitialized = false;
    private volatile boolean frameReady = false;
    private String glVersion;
    private ProgressMeter activeMeterRef = null;
    private String currentLabel = "";
    private Field earlyProgressMethod;
    private int inferredStage = 0;
    private float smoothedProgress = 0.0f;

    public String name() {
        return "pinperearlywindow";
    }

    public Runnable initialize(String[] args) {
        return this.initCore();
    }

    private ProgressMeter getEarlyProgress() {
        try {
            if (this.earlyProgressMethod == null) {
                this.earlyProgressMethod = ImmediateWindowHandler.class.getDeclaredField("earlyProgress");
                this.earlyProgressMethod.setAccessible(true);
            }
            return (ProgressMeter)this.earlyProgressMethod.get(null);
        }
        catch (Exception e) {
            logger.error("Failed to get early progress", (Throwable)e);
            return null;
        }
    }

    private Runnable initCore() {
        GLFWErrorCallback.createPrint((PrintStream)System.err).set();
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("GLFW init failed");
        }
        this.createWindowWithGLVersionDetection();
        GLFW.glfwShowWindow((long)this.window);
        GLFW.glfwMakeContextCurrent((long)this.window);
        GLFW.glfwSwapInterval((int)1);
        GL.createCapabilities();
        String glRenderer = GL11.glGetString((int)7937);
        String glVersionStr = GL11.glGetString((int)7938);
        String glVendor = GL11.glGetString((int)7936);
        logger.info("GL info: {} GL version {}, {}", new Object[]{glRenderer, glVersionStr, glVendor});
        this.renderer = new PinperRenderer(1100, 600);
        GLFW.glfwMakeContextCurrent((long)0L);
        this.scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "EarlyWindow-Renderer");
            t.setDaemon(true);
            return t;
        });
        this.scheduler.scheduleAtFixedRate(() -> {
            if (this.active && !this.handedOff && this.window != 0L) {
                try {
                    GLFW.glfwMakeContextCurrent((long)this.window);
                    if (!this.renderThreadInitialized) {
                        GL.createCapabilities();
                        this.renderThreadInitialized = true;
                        logger.info("Render thread GL initialized");
                    }
                    this.updateRealProgress();
                    this.renderer.updateAnimation();
                    this.renderer.renderFrame();
                    GLFW.glfwSwapBuffers((long)this.window);
                    Object object = this.frameLock;
                    synchronized (object) {
                        this.frameReady = true;
                        this.frameLock.notifyAll();
                    }
                    GLFW.glfwMakeContextCurrent((long)0L);
                    LockSupport.parkNanos(1000000L);
                }
                catch (Exception e) {
                    logger.error("Render error", (Throwable)e);
                }
            }
        }, 0L, 16L, TimeUnit.MILLISECONDS);
        StartupNotificationManager.modLoaderConsumer().ifPresent(c -> c.accept("NeoForge loading"));
        return () -> GLFW.glfwSetWindowShouldClose((long)this.window, (boolean)false);
    }

    private void createWindowWithGLVersionDetection() {
        List skipVersions;
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)131076, (int)0);
        GLFW.glfwWindowHint((int)131075, (int)0);
        GLFW.glfwWindowHint((int)131077, (int)0);
        GLFW.glfwWindowHint((int)131082, (int)0);
        GLFW.glfwWindowHint((int)135184, (int)1);
        GLFW.glfwWindowHint((int)139265, (int)196609);
        GLFW.glfwWindowHint((int)139275, (int)221185);
        long primaryMonitor = GLFW.glfwGetPrimaryMonitor();
        if (primaryMonitor == 0L) {
            throw new IllegalStateException("Can't find a primary monitor");
        }
        GLFWVidMode vidMode = GLFW.glfwGetVideoMode((long)primaryMonitor);
        if (vidMode == null) {
            throw new IllegalStateException("Can't get a resolution");
        }
        long window = 0L;
        int versidx = 0;
        try {
            skipVersions = FMLConfig.getListConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_SKIP_GL_VERSIONS);
        }
        catch (Exception e) {
            skipVersions = List.of();
            logger.debug("Could not get skip GL versions from config: {}", (Object)e.getMessage());
        }
        String[] lastGLError = new String[GL_VERSIONS.length];
        do {
            String glVersionToTry;
            if (skipVersions.contains(glVersionToTry = GL_VERSIONS[versidx][0] + "." + GL_VERSIONS[versidx][1])) {
                logger.info("Skipping GL version {} because of configuration", (Object)glVersionToTry);
                ++versidx;
                continue;
            }
            logger.info("Trying GL version {}", (Object)glVersionToTry);
            GLFW.glfwWindowHint((int)139266, (int)GL_VERSIONS[versidx][0]);
            GLFW.glfwWindowHint((int)139267, (int)GL_VERSIONS[versidx][1]);
            if (GL_VERSIONS[versidx][0] >= 3 && GL_VERSIONS[versidx][1] >= 2) {
                GLFW.glfwWindowHint((int)139272, (int)204802);
            } else {
                GLFW.glfwWindowHint((int)139272, (int)0);
            }
            GLFW.glfwWindowHint((int)139270, (int)0);
            window = GLFW.glfwCreateWindow((int)1100, (int)600, (CharSequence)"Loading Minecraft...", (long)0L, (long)0L);
            int erridx = versidx;
            this.handleLastGLFWError((error, description) -> {
                lastGLError[erridx] = String.format("Trying %d.%d: GLFW error: [0x%X]%s", GL_VERSIONS[erridx][0], GL_VERSIONS[erridx][1], error, description);
            });
            if (lastGLError[versidx] != null) {
                logger.trace(lastGLError[versidx]);
            }
            ++versidx;
        } while (window == 0L && versidx < GL_VERSIONS.length);
        if (versidx == GL_VERSIONS.length && window == 0L) {
            List finalSkipVersions = skipVersions;
            String errorMsg = "Failed to find a valid GLFW profile.\nWe tried " + Arrays.stream(GL_VERSIONS).map(p -> p[0] + "." + p[1]).filter(o -> !finalSkipVersions.contains(o)).collect(Collectors.joining(", ")) + " but none of them worked.\n" + Arrays.stream(lastGLError).filter(Objects::nonNull).collect(Collectors.joining("\n"));
            logger.error(errorMsg);
            throw new IllegalStateException("Failed to create a GLFW window with any GL profile");
        }
        String requestedVersion = GL_VERSIONS[versidx - 1][0] + "." + GL_VERSIONS[versidx - 1][1];
        int maj = GLFW.glfwGetWindowAttrib((long)window, (int)139266);
        int min = GLFW.glfwGetWindowAttrib((long)window, (int)139267);
        String gotVersion = maj + "." + min;
        logger.info("Requested GL version {} got version {}", (Object)requestedVersion, (Object)gotVersion);
        this.glVersion = gotVersion;
        this.window = window;
        int[] x = new int[1];
        int[] y = new int[1];
        GLFW.glfwGetMonitorPos((long)primaryMonitor, (int[])x, (int[])y);
        int monitorX = x[0];
        int monitorY = y[0];
        GLFW.glfwSetWindowPos((long)window, (int)((vidMode.width() - 1100) / 2 + monitorX), (int)((vidMode.height() - 600) / 2 + monitorY));
    }

    private void handleLastGLFWError(BiConsumer<Integer, String> handler) {
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            PointerBuffer pointerbuffer = memorystack.mallocPointer(1);
            int error = GLFW.glfwGetError((PointerBuffer)pointerbuffer);
            if (error != 0) {
                long pDescription = pointerbuffer.get();
                String description = pDescription == 0L ? "" : MemoryUtil.memUTF8((long)pDescription);
                handler.accept(error, description);
            }
        }
    }

    private void updateRealProgress() {
        block8: {
            try {
                ProgressMeter currentMeter = this.getEarlyProgress();
                if (currentMeter != null) {
                    String newLabel;
                    if (this.activeMeterRef == null || !this.activeMeterRef.equals(currentMeter)) {
                        this.activeMeterRef = currentMeter;
                        this.renderer.setProgress(0.0f);
                        this.smoothedProgress = 0.0f;
                    }
                    if (!this.currentLabel.equals(newLabel = currentMeter.label().getText())) {
                        this.currentLabel = newLabel;
                        this.updateHintFromMessage(this.currentLabel);
                        logger.info("Label is update: {}", (Object)this.currentLabel);
                    }
                    this.inferredStage = this.inferStageFromMessage(this.currentLabel);
                    float targetStart = STAGE_STARTS[this.inferredStage];
                    float targetEnd = STAGE_ENDS[this.inferredStage];
                    float next = this.smoothedProgress;
                    if (next < targetStart) {
                        next = targetStart;
                    }
                    float maxStep = 0.02f;
                    if (next < targetEnd) {
                        next = Math.min(targetEnd, next + maxStep);
                    }
                    this.smoothedProgress = Math.max(this.smoothedProgress, next);
                    this.renderer.setProgress(Math.min(0.999f, this.smoothedProgress));
                } else {
                    this.renderer.setProgress(1.0f);
                    this.activeMeterRef = null;
                }
            }
            catch (Exception e) {
                logger.warn("Error reading progress: {}", (Object)e.getMessage());
                float currentProgress = this.renderer.getProgress();
                if (!(currentProgress < 0.95f)) break block8;
                float bumped = Math.min(0.95f, currentProgress + 0.002f);
                this.smoothedProgress = Math.max(this.smoothedProgress, bumped);
                this.renderer.setProgress(this.smoothedProgress);
            }
        }
    }

    private int inferStageFromMessage(String message) {
        if (message == null) {
            return this.inferredStage;
        }
        if (message.equals("Bootstrapping Minecraft")) {
            return 0;
        }
        if (message.equals("Discovering mod files")) {
            return 1;
        }
        if (message.contains("Found") && message.contains("mod candidates")) {
            return 2;
        }
        if (message.contains("language provider")) {
            return 3;
        }
        if (message.equals("Scanning mod candidates")) {
            return 4;
        }
        if (message.equals("Loading bootstrap resources")) {
            return 5;
        }
        if (message.equals("Initializing Game Graphics")) {
            return 6;
        }
        return this.inferredStage;
    }

    private void updateHintFromMessage(String message) {
        if (message.equals("Bootstrapping Minecraft") || message.equals("Discovering mod files") || message.contains("Found") && message.contains("mod candidates")) {
            this.renderer.setHintStage(0);
        } else if (message.contains("language provider") || message.equals("Scanning mod candidates") || message.equals("Loading bootstrap resources")) {
            this.renderer.setHintStage(1);
        } else if (message.equals("Initializing Game Graphics")) {
            this.renderer.setHintStage(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void periodicTick() {
        if (this.active && !this.handedOff && this.window != 0L) {
            Object object = this.frameLock;
            synchronized (object) {
                if (!this.frameReady) {
                    try {
                        this.frameLock.wait(50L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                this.frameReady = false;
            }
            GLFW.glfwPollEvents();
        }
    }

    public long setupMinecraftWindow(IntSupplier width, IntSupplier height, Supplier<String> title, LongSupplier monitor) {
        List meters;
        ImmediateWindowHandler.updateProgress((String)"Initializing Game Graphics");
        long startWait = System.nanoTime();
        long maxWait = 3000000000L;
        while ((meters = StartupNotificationManager.getCurrentProgress()) != null && !meters.isEmpty()) {
            if (this.window != 0L) {
                GLFW.glfwPollEvents();
            }
            if (System.nanoTime() - startWait > 3000000000L) {
                logger.warn("Timed out waiting for progress meters to complete; proceeding with handoff");
                break;
            }
            LockSupport.parkNanos(16000000L);
        }
        this.active = false;
        this.handedOff = true;
        if (this.scheduler != null) {
            this.scheduler.shutdown();
            try {
                this.scheduler.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        GLFW.glfwMakeContextCurrent((long)this.window);
        if (!this.renderThreadInitialized) {
            GL.createCapabilities();
        }
        this.renderer.setProgress(1.0f);
        this.renderer.setHintStage(2);
        this.renderer.renderFrame();
        GLFW.glfwSwapBuffers((long)this.window);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (this.window != 0L) {
            GLFW.glfwSetWindowAttrib((long)this.window, (int)131077, (int)1);
            GLFW.glfwSetWindowAttrib((long)this.window, (int)131075, (int)1);
        }
        return this.window;
    }

    public boolean positionWindow(Optional<Object> monitor, IntConsumer w, IntConsumer h, IntConsumer x, IntConsumer y) {
        return false;
    }

    public void updateFramebufferSize(IntConsumer width, IntConsumer height) {
        width.accept(this.width);
        height.accept(this.height);
    }

    public <T> Supplier<T> loadingOverlay(Supplier<?> mc, Supplier<?> ri, Consumer<Optional<Throwable>> ex, boolean fade) {
        return () -> null;
    }

    public void updateModuleReads(ModuleLayer layer) {
    }

    public String getGLVersion() {
        return this.glVersion != null ? this.glVersion : "3.3";
    }

    public void crash(String message) {
        logger.error("Early window crash: {}", (Object)message);
        this.close();
    }

    public void close() {
        this.active = false;
        if (this.scheduler != null) {
            this.scheduler.shutdown();
            try {
                this.scheduler.awaitTermination(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.renderer != null) {
            if (this.window != 0L) {
                GLFW.glfwMakeContextCurrent((long)this.window);
            }
            this.renderer.close();
        }
        if (!this.handedOff && this.window != 0L) {
            Callbacks.glfwFreeCallbacks((long)this.window);
            GLFW.glfwDestroyWindow((long)this.window);
        }
        GLFW.glfwTerminate();
        SimpleBufferBuilder.destroy();
    }
}

