/*
 * Decompiled with CFR 0.152.
 */
package one.pkg.pinperlauncher;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import one.pkg.pinperlauncher.HintAnimator;
import one.pkg.pinperlauncher.ResourceLoader;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.stb.STBTTAlignedQuad;
import org.lwjgl.stb.STBTTBakedChar;
import org.lwjgl.stb.STBTruetype;
import org.lwjgl.system.MemoryStack;

public class PinperRenderer {
    private final int width;
    private final int height;
    private final HintAnimator hintAnimator = new HintAnimator(new String[]{"Initialize the game", "Loading resources", "Waiting for the game window"});
    private final int backgroundTex;
    private final int fontAtlasW = 512;
    private final int fontAtlasH = 512;
    private final float fontPixelHeight = 40.0f;
    private float progress = 0.0f;
    private long lastUpdateTime = System.currentTimeMillis();
    private STBTTBakedChar.Buffer fontChars;
    private int fontTexId;
    private float smoothProgress = 0.0f;

    public PinperRenderer(int width, int height) {
        this.width = width;
        this.height = height;
        GL11.glViewport((int)0, (int)0, (int)width, (int)height);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)width, (double)height, (double)0.0, (double)-1.0, (double)1.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.backgroundTex = ResourceLoader.loadBackgroundTexture();
        GL11.glEnable((int)3553);
        ByteBuffer ttf = ResourceLoader.loadFontTTF();
        ByteBuffer bitmap = BufferUtils.createByteBuffer((int)262144);
        this.fontChars = STBTTBakedChar.malloc((int)96);
        int res = STBTruetype.stbtt_BakeFontBitmap((ByteBuffer)ttf, (float)40.0f, (ByteBuffer)bitmap, (int)512, (int)512, (int)32, (STBTTBakedChar.Buffer)this.fontChars);
        ResourceLoader.free(ttf);
        if (res <= 0) {
            throw new RuntimeException("Failed to bake TTF font (code=" + res + ")");
        }
        this.fontTexId = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)this.fontTexId);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexImage2D((int)3553, (int)0, (int)6406, (int)512, (int)512, (int)0, (int)6406, (int)5121, (ByteBuffer)bitmap);
    }

    public void renderFrame() {
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glClear((int)16384);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2903);
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawBackground();
        this.drawProgressBar();
        this.drawHint();
    }

    public void updateAnimation() {
        float diff;
        long now = System.currentTimeMillis();
        long dtMs = now - this.lastUpdateTime;
        float dt = Math.max(0.0f, Math.min(0.1f, (float)dtMs / 1000.0f));
        float target = this.progress;
        if (target < this.smoothProgress) {
            target = this.smoothProgress;
        }
        if ((diff = target - this.smoothProgress) > 0.0f) {
            boolean largeJump = diff > 0.05f;
            float maxSpeedPerSec = largeJump ? 0.25f : 0.8f;
            float easeK = largeJump ? 4.0f : 6.0f;
            float minStepPerSec = largeJump ? 0.004f : 0.01f;
            float maxStep = maxSpeedPerSec * dt;
            float easedStep = diff * (1.0f - (float)Math.exp(-easeK * dt));
            float step = Math.min(Math.max(easedStep, 0.0f), Math.max(maxStep, minStepPerSec * dt));
            step = Math.min(step, diff);
            this.smoothProgress += step;
        }
        this.hintAnimator.setProgress(this.smoothProgress);
        this.hintAnimator.update(dtMs);
        this.lastUpdateTime = now;
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        this.progress = Math.max(0.0f, Math.min(1.0f, progress));
    }

    public void setHintStage(int stage) {
        this.hintAnimator.setHintStage(stage);
    }

    private void drawBackground() {
        if (this.backgroundTex == 0) {
            return;
        }
        GL11.glEnable((int)3553);
        GL11.glBindTexture((int)3553, (int)this.backgroundTex);
        GL11.glTexEnvi((int)8960, (int)8704, (int)7681);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2f((float)this.width, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2f((float)this.width, (float)this.height);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2f((float)0.0f, (float)this.height);
        GL11.glEnd();
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
    }

    private void drawProgressBar() {
        int barHeight = 16;
        int yTop = this.height - barHeight;
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)0.06f, (float)0.14f, (float)0.22f, (float)0.55f);
        GL11.glBegin((int)7);
        GL11.glVertex2f((float)0.0f, (float)yTop);
        GL11.glVertex2f((float)this.width, (float)yTop);
        GL11.glVertex2f((float)this.width, (float)this.height);
        GL11.glVertex2f((float)0.0f, (float)this.height);
        GL11.glEnd();
        GL11.glColor4f((float)0.05f, (float)0.1f, (float)0.16f, (float)0.85f);
        GL11.glBegin((int)7);
        GL11.glVertex2f((float)0.0f, (float)yTop);
        GL11.glVertex2f((float)this.width, (float)yTop);
        GL11.glVertex2f((float)this.width, (float)this.height);
        GL11.glVertex2f((float)0.0f, (float)this.height);
        GL11.glEnd();
        float barWidth = (float)this.width * Math.max(0.0f, Math.min(1.0f, this.progress));
        GL11.glBegin((int)7);
        GL11.glColor4f((float)0.06f, (float)0.26f, (float)0.43f, (float)0.95f);
        GL11.glVertex2f((float)0.0f, (float)yTop);
        GL11.glVertex2f((float)(barWidth * 0.5f), (float)yTop);
        GL11.glColor4f((float)0.12f, (float)0.38f, (float)0.66f, (float)0.95f);
        GL11.glVertex2f((float)(barWidth * 0.5f), (float)this.height);
        GL11.glVertex2f((float)0.0f, (float)this.height);
        GL11.glEnd();
        GL11.glBegin((int)7);
        GL11.glColor4f((float)0.12f, (float)0.38f, (float)0.66f, (float)0.95f);
        GL11.glVertex2f((float)(barWidth * 0.5f), (float)yTop);
        GL11.glVertex2f((float)barWidth, (float)yTop);
        GL11.glColor4f((float)0.18f, (float)0.49f, (float)0.89f, (float)0.95f);
        GL11.glVertex2f((float)barWidth, (float)this.height);
        GL11.glVertex2f((float)(barWidth * 0.5f), (float)this.height);
        GL11.glEnd();
        float glossH = Math.max(1.0f, (float)barHeight * 0.35f);
        GL11.glBegin((int)7);
        GL11.glColor4f((float)0.5f, (float)0.7f, (float)1.0f, (float)0.18f);
        GL11.glVertex2f((float)0.0f, (float)yTop);
        GL11.glVertex2f((float)barWidth, (float)yTop);
        GL11.glColor4f((float)0.5f, (float)0.7f, (float)1.0f, (float)0.0f);
        GL11.glVertex2f((float)barWidth, (float)((float)yTop + glossH));
        GL11.glVertex2f((float)0.0f, (float)((float)yTop + glossH));
        GL11.glEnd();
        GL11.glLineWidth((float)1.0f);
        GL11.glColor4f((float)0.1f, (float)0.28f, (float)0.46f, (float)0.65f);
        GL11.glBegin((int)2);
        GL11.glVertex2f((float)0.5f, (float)((float)yTop + 0.5f));
        GL11.glVertex2f((float)((float)this.width - 0.5f), (float)((float)yTop + 0.5f));
        GL11.glVertex2f((float)((float)this.width - 0.5f), (float)((float)this.height - 0.5f));
        GL11.glVertex2f((float)0.5f, (float)((float)this.height - 0.5f));
        GL11.glEnd();
        GL11.glLineWidth((float)1.0f);
        GL11.glEnable((int)3553);
    }

    private void drawHint() {
        String hint = this.hintAnimator.getCurrentHint();
        float alpha = this.hintAnimator.getOpacity();
        int barHeight = 16;
        int marginRight = 40;
        int marginBottom = 28;
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer xb = stack.floats(0.0f);
            FloatBuffer yb = stack.floats(0.0f);
            STBTTAlignedQuad quad = STBTTAlignedQuad.malloc((MemoryStack)stack);
            for (int i = 0; i < hint.length(); ++i) {
                char ch = hint.charAt(i);
                if (ch < ' ' || ch >= '\u0080') continue;
                STBTruetype.stbtt_GetBakedQuad((STBTTBakedChar.Buffer)this.fontChars, (int)512, (int)512, (int)(ch - 32), (FloatBuffer)xb, (FloatBuffer)yb, (STBTTAlignedQuad)quad, (boolean)true);
            }
            float textWidth = xb.get(0);
            float xStart = Math.max((float)marginRight, (float)this.width - textWidth - (float)marginRight);
            float yStart = this.height - barHeight - marginBottom;
            xb.put(0, xStart);
            yb.put(0, yStart);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            boolean wasTexEnabled = GL11.glIsEnabled((int)3553);
            if (!wasTexEnabled) {
                GL11.glEnable((int)3553);
            }
            GL11.glBindTexture((int)3553, (int)this.fontTexId);
            GL11.glBegin((int)7);
            for (int i = 0; i < hint.length(); ++i) {
                char ch = hint.charAt(i);
                if (ch < ' ' || ch >= '\u0080') continue;
                STBTruetype.stbtt_GetBakedQuad((STBTTBakedChar.Buffer)this.fontChars, (int)512, (int)512, (int)(ch - 32), (FloatBuffer)xb, (FloatBuffer)yb, (STBTTAlignedQuad)quad, (boolean)true);
                GL11.glTexCoord2f((float)quad.s0(), (float)quad.t0());
                GL11.glVertex2f((float)quad.x0(), (float)quad.y0());
                GL11.glTexCoord2f((float)quad.s1(), (float)quad.t0());
                GL11.glVertex2f((float)quad.x1(), (float)quad.y0());
                GL11.glTexCoord2f((float)quad.s1(), (float)quad.t1());
                GL11.glVertex2f((float)quad.x1(), (float)quad.y1());
                GL11.glTexCoord2f((float)quad.s0(), (float)quad.t1());
                GL11.glVertex2f((float)quad.x0(), (float)quad.y1());
            }
            GL11.glEnd();
            if (!wasTexEnabled) {
                GL11.glDisable((int)3553);
            }
        }
    }

    public void close() {
        if (this.fontChars != null) {
            this.fontChars.free();
            this.fontChars = null;
        }
        if (this.fontTexId != 0) {
            GL11.glDeleteTextures((int)this.fontTexId);
            this.fontTexId = 0;
        }
    }
}

