/*
 * Decompiled with CFR 0.152.
 */
package one.pkg.pinperlauncher;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.neoforged.fml.loading.FMLPaths;
import one.pkg.pinperlauncher.PinperEarlyWindow;
import org.lwjgl.opengl.GL11;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class ResourceLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int loadBackgroundTexture() {
        int[] w = new int[1];
        int[] h = new int[1];
        ByteBuffer image = null;
        try {
            IntBuffer ic;
            IntBuffer ih;
            IntBuffer iw;
            MemoryStack stack;
            ByteBuffer buffer;
            byte[] data;
            Path override = FMLPaths.CONFIGDIR.get().resolve("pinper.png");
            if (Files.exists(override, new LinkOption[0])) {
                data = Files.readAllBytes(override);
                buffer = MemoryUtil.memAlloc((int)data.length).put(data);
                buffer.flip();
                try {
                    stack = MemoryStack.stackPush();
                    try {
                        iw = stack.mallocInt(1);
                        ih = stack.mallocInt(1);
                        ic = stack.mallocInt(1);
                        ByteBuffer tmp = STBImage.stbi_load_from_memory((ByteBuffer)buffer, (IntBuffer)iw, (IntBuffer)ih, (IntBuffer)ic, (int)4);
                        if (tmp != null && iw.get(0) == 800 && ih.get(0) == 450) {
                            image = tmp;
                            w[0] = 800;
                            h[0] = 450;
                        } else if (tmp != null) {
                            STBImage.stbi_image_free((ByteBuffer)tmp);
                        }
                    }
                    finally {
                        if (stack != null) {
                            stack.close();
                        }
                    }
                }
                finally {
                    MemoryUtil.memFree((Buffer)buffer);
                }
            }
            if (image == null) {
                data = ResourceLoader.readClasspathResource("background.png");
                if (data == null) {
                    throw new RuntimeException("Missing internal background.png");
                }
                buffer = MemoryUtil.memAlloc((int)data.length).put(data);
                buffer.flip();
                try {
                    stack = MemoryStack.stackPush();
                    try {
                        iw = stack.mallocInt(1);
                        ih = stack.mallocInt(1);
                        ic = stack.mallocInt(1);
                        image = STBImage.stbi_load_from_memory((ByteBuffer)buffer, (IntBuffer)iw, (IntBuffer)ih, (IntBuffer)ic, (int)4);
                        if (image == null) {
                            throw new RuntimeException("Failed to decode internal background.png");
                        }
                        w[0] = iw.get(0);
                        h[0] = ih.get(0);
                    }
                    finally {
                        if (stack != null) {
                            stack.close();
                        }
                    }
                }
                finally {
                    MemoryUtil.memFree((Buffer)buffer);
                }
            }
            int tex = GL11.glGenTextures();
            GL11.glBindTexture((int)3553, (int)tex);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)w[0], (int)h[0], (int)0, (int)6408, (int)5121, image);
            STBImage.stbi_image_free(image);
            return tex;
        }
        catch (Exception e) {
            PinperEarlyWindow.logger.error("Background texture load failed", (Throwable)e);
            return 0;
        }
    }

    private static byte[] readClasspathResource(String name) throws Exception {
        try (InputStream in = ResourceLoader.class.getClassLoader().getResourceAsStream(name);){
            if (in == null) {
                byte[] byArray = null;
                return byArray;
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            in.transferTo(bout);
            byte[] byArray = bout.toByteArray();
            return byArray;
        }
    }

    public static ByteBuffer loadFontTTF() {
        try {
            Path override = FMLPaths.CONFIGDIR.get().resolve("pinper.ttf");
            if (Files.exists(override, new LinkOption[0])) {
                byte[] bytes = Files.readAllBytes(override);
                ByteBuffer buf = MemoryUtil.memAlloc((int)bytes.length);
                buf.put(bytes).flip();
                return buf;
            }
            byte[] data = ResourceLoader.readClasspathResource("Overpass-Light.ttf");
            if (data == null) {
                throw new RuntimeException("Missing internal Overpass-Light.ttf");
            }
            ByteBuffer buffer = MemoryUtil.memAlloc((int)data.length);
            buffer.put(data).flip();
            return buffer;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load font TTF", e);
        }
    }

    public static void free(ByteBuffer buf) {
        if (buf != null) {
            MemoryUtil.memFree((Buffer)buf);
        }
    }
}

