/*
 * Decompiled with CFR 0.152.
 */
package one.pkg.pinperlauncher.util;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.chrono.ChronoLocalDate;
import java.time.temporal.ChronoUnit;
import org.jetbrains.annotations.NotNull;

public class HolidayChecker {
    public static boolean isAnySupportedHoliday() {
        return HolidayChecker.isAnySupportedHoliday(LocalDate.now());
    }

    public static boolean isAnySupportedHoliday(LocalDate date) {
        for (Holiday h : Holiday.VALUES) {
            if (!h.is(date)) continue;
            return true;
        }
        return false;
    }

    public static boolean isChristmas() {
        return HolidayChecker.isChristmas(LocalDate.now());
    }

    public static boolean isChristmas(LocalDate d) {
        return d.getMonth() == Month.DECEMBER && d.getDayOfMonth() == 25;
    }

    public static boolean isChristmasEve() {
        return HolidayChecker.isChristmasEve(LocalDate.now());
    }

    public static boolean isChristmasEve(LocalDate d) {
        return d.getMonth() == Month.DECEMBER && d.getDayOfMonth() == 24;
    }

    public static boolean isHalloween() {
        return HolidayChecker.isHalloween(LocalDate.now());
    }

    public static boolean isHalloween(LocalDate d) {
        return d.getMonth() == Month.OCTOBER && d.getDayOfMonth() == 31;
    }

    public static boolean isNewYear() {
        return HolidayChecker.isNewYear(LocalDate.now());
    }

    public static boolean isNewYear(LocalDate d) {
        return d.getMonth() == Month.JANUARY && d.getDayOfMonth() == 1;
    }

    public static boolean isAprilFools() {
        return HolidayChecker.isAprilFools(LocalDate.now());
    }

    public static boolean isAprilFools(LocalDate d) {
        return d.getMonth() == Month.APRIL && d.getDayOfMonth() == 1;
    }

    public static boolean isMidAutumn() {
        return HolidayChecker.isMidAutumn(LocalDate.now());
    }

    public static boolean isMidAutumn(LocalDate d) {
        LocalDate approx = MidAutumnApproximate.compute(d.getYear());
        return d.equals(approx);
    }

    public static boolean isNthWeekdayOfMonth(Month month, DayOfWeek weekday, int nth) {
        return HolidayChecker.isNthWeekdayOfMonth(LocalDate.now(), month, weekday, nth);
    }

    public static boolean isNthWeekdayOfMonth(LocalDate date, Month month, DayOfWeek weekday, int nth) {
        if (date.getMonth() != month || date.getDayOfWeek() != weekday) {
            return false;
        }
        LocalDate first = LocalDate.of(date.getYear(), month, 1);
        int shift = (weekday.getValue() - first.getDayOfWeek().getValue() + 7) % 7;
        LocalDate nthDate = first.plusDays((long)shift + (long)(nth - 1) * 7L);
        return date.equals(nthDate);
    }

    public static enum Holiday {
        CHRISTMAS(new String[]{"Decking the halls", "Reindeer delivering resources", "Awaiting snowfall to open the game"}){

            @Override
            public boolean isToday() {
                return HolidayChecker.isChristmas();
            }

            @Override
            public boolean is(LocalDate date) {
                return HolidayChecker.isChristmas(date);
            }
        }
        ,
        CHRISTMAS_EVE(new String[]{"Lighting candles for the eve", "Secretly packing presents", "Waiting for midnight chimes to launch"}){

            @Override
            public boolean isToday() {
                return HolidayChecker.isChristmasEve();
            }

            @Override
            public boolean is(LocalDate date) {
                return HolidayChecker.isChristmasEve(date);
            }
        }
        ,
        HALLOWEEN(new String[]{"Jack-o\u2019-lanterns aglow", "Witches brewing resource potions", "Trick or treat? Awaiting the game\u2019s reveal"}){

            @Override
            public boolean isToday() {
                return HolidayChecker.isHalloween();
            }

            @Override
            public boolean is(LocalDate date) {
                return HolidayChecker.isHalloween(date);
            }
        }
        ,
        NEW_YEAR(new String[]{"Warming up the New Year engine", "Fireworks loading resources", "Counting down to a fresh start"}){

            @Override
            public boolean isToday() {
                return HolidayChecker.isNewYear();
            }

            @Override
            public boolean is(LocalDate date) {
                return HolidayChecker.isNewYear(date);
            }
        }
        ,
        APRIL_FOOLS(new String[]{"Loading seriously (promise)", "Resources performing tricks", "Keep a playful doubt\u2014game incoming"}){

            @Override
            public boolean isToday() {
                return HolidayChecker.isAprilFools();
            }

            @Override
            public boolean is(LocalDate date) {
                return HolidayChecker.isAprilFools(date);
            }
        }
        ,
        MID_AUTUMN(new String[]{"Mooncakes ready, osmanthus in the air", "Resources arriving from the Moon Palace", "When the moon is full, the game shall begin"}){

            @Override
            public boolean isToday() {
                return HolidayChecker.isMidAutumn();
            }

            @Override
            public boolean is(LocalDate date) {
                return HolidayChecker.isMidAutumn(date);
            }
        }
        ,
        NONE(new String[]{"Initialize the game", "Loading resources", "Waiting for the game window"}){

            @Override
            public boolean isToday() {
                return false;
            }

            @Override
            public boolean is(LocalDate date) {
                return false;
            }
        };

        private static final Holiday[] VALUES;
        public final String[] hints;

        private Holiday(String ... hints) {
            this.hints = hints;
        }

        @NotNull
        public static Holiday getInstance() {
            for (Holiday holiday : VALUES) {
                if (holiday.equals((Object)NONE) || !holiday.isToday()) continue;
                return holiday;
            }
            return NONE;
        }

        public abstract boolean isToday();

        public abstract boolean is(LocalDate var1);

        static {
            VALUES = Holiday.values();
        }
    }

    private static final class MidAutumnApproximate {
        private static final LocalDate REFERENCE_NEW_MOON = LocalDate.of(2000, 1, 21);
        private static final double SYNODIC_MONTH = 29.530588;
        private static final double HALF_SYNODIC = 14.765294;

        private MidAutumnApproximate() {
        }

        static LocalDate compute(int year) {
            LocalDate firstFullMoon;
            LocalDate searchStart = LocalDate.of(year, 9, 1);
            LocalDate searchEnd = LocalDate.of(year, 10, 15);
            LocalDate searchDate = LocalDate.of(year, 9, 23);
            long daysFromRefToStart = ChronoUnit.DAYS.between(REFERENCE_NEW_MOON, searchStart);
            long k = Math.round(((double)daysFromRefToStart - 14.765294) / 29.530588);
            LocalDate candidate = firstFullMoon = REFERENCE_NEW_MOON.plusDays(Math.round((double)k * 29.530588 + 14.765294));
            LocalDate best = null;
            long bestScore = Long.MAX_VALUE;
            for (int i = 0; i < 4; ++i) {
                long score;
                if (!candidate.isBefore(searchStart) && !candidate.isAfter(searchEnd) && (score = Math.abs(MidAutumnApproximate.daysBetween(candidate, searchDate))) < bestScore) {
                    bestScore = score;
                    best = candidate;
                }
                candidate = candidate.plusDays(Math.round(29.530588));
            }
            if (best == null) {
                best = firstFullMoon;
            }
            if (best.isBefore(LocalDate.of(year, 9, 7))) {
                best = best.plusDays(Math.round(29.530588));
            } else if (best.isAfter(LocalDate.of(year, 10, 8))) {
                best = best.minusDays(Math.round(29.530588));
            }
            return best;
        }

        private static long daysBetween(ChronoLocalDate a, ChronoLocalDate b) {
            return Math.abs(ChronoUnit.DAYS.between(a, b));
        }
    }
}

