/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.expore.datagen;

import com.blocklegend001.expore.blocks.ModBlocks;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ItemModelOutput;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ModModelProvider
extends ModelProvider {
    private final PackOutput.PathProvider blockStatePathProvider;
    private final PackOutput.PathProvider itemInfoPathProvider;
    private final PackOutput.PathProvider modelPathProvider;
    protected final String modId;

    public ModModelProvider(PackOutput packOutput, String modId) {
        super(packOutput);
        this.blockStatePathProvider = packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "blockstates");
        this.itemInfoPathProvider = packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "items");
        this.modelPathProvider = packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "models");
        this.modId = modId;
    }

    protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
        this.blockModel(blockModels, (Block)ModBlocks.EXP_ORE.get());
        this.blockModel(blockModels, (Block)ModBlocks.DEEPSLATE_EXP_ORE.get());
        this.blockModel(blockModels, (Block)ModBlocks.NETHER_EXP_ORE.get());
        this.blockModel(blockModels, (Block)ModBlocks.END_EXP_ORE.get());
    }

    public void blockModel(BlockModelGenerators blockModels, Block block) {
        blockModels.createTrivialCube(block);
        ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)block);
        ResourceLocation textureLoc = ResourceLocation.fromNamespaceAndPath((String)blockId.getNamespace(), (String)("block/" + blockId.getPath()));
        blockModels.itemModelOutput.accept(block.asItem(), (ItemModel.Unbaked)new BlockModelWrapper.Unbaked(textureLoc, Collections.emptyList()));
    }

    public CompletableFuture<?> run(CachedOutput output) {
        ModelProvider.ItemInfoCollector itemCollector = new ModelProvider.ItemInfoCollector(this::getKnownItems);
        ModelProvider.BlockStateGeneratorCollector blockStateCollector = new ModelProvider.BlockStateGeneratorCollector(this::getKnownBlocks);
        ModelProvider.SimpleModelCollector simpleModelCollector = new ModelProvider.SimpleModelCollector();
        this.registerModels(new BlockModelGenerators((Consumer)blockStateCollector, (ItemModelOutput)itemCollector, (BiConsumer)simpleModelCollector), new ItemModelGenerators((ItemModelOutput)itemCollector, (BiConsumer)simpleModelCollector));
        blockStateCollector.validate();
        itemCollector.finalizeAndValidate();
        return CompletableFuture.allOf(blockStateCollector.save(output, this.blockStatePathProvider), simpleModelCollector.save(output, this.modelPathProvider), itemCollector.save(output, this.itemInfoPathProvider));
    }

    protected Stream<Block> getKnownBlocks() {
        return BuiltInRegistries.BLOCK.stream().filter(block -> Optional.of(BuiltInRegistries.BLOCK.getKey(block)).filter(key -> key.getNamespace().equals(this.modId)).isPresent());
    }

    protected Stream<Item> getKnownItems() {
        return BuiltInRegistries.ITEM.stream().filter(item -> Optional.of(BuiltInRegistries.ITEM.getKey(item)).filter(key -> key.getNamespace().equals(this.modId)).isPresent());
    }
}

