/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.expore.world.feature;

import com.blocklegend001.expore.blocks.ModBlocks;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.List;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class ModConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> OVERWORLD_EXP_ORE_KEY = ModConfiguredFeatures.registerKey("overworld_exp_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NETHER_EXP_ORE_KEY = ModConfiguredFeatures.registerKey("nether_exp_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> END_EXP_ORE_KEY = ModConfiguredFeatures.registerKey("end_exp_ore");
    public static final Supplier<List<OreConfiguration.TargetBlockState>> OVERWORLD_EXP_ORES = Suppliers.memoize(() -> List.of(OreConfiguration.target((RuleTest)new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES), (BlockState)((Block)ModBlocks.EXP_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES), (BlockState)((Block)ModBlocks.DEEPSLATE_EXP_ORE.get()).defaultBlockState())));
    public static final Supplier<List<OreConfiguration.TargetBlockState>> NETHER_EXP_ORES = Suppliers.memoize(() -> List.of(OreConfiguration.target((RuleTest)new BlockMatchTest(Blocks.NETHERRACK), (BlockState)((Block)ModBlocks.NETHER_EXP_ORE.get()).defaultBlockState())));
    public static final Supplier<List<OreConfiguration.TargetBlockState>> END_EXP_ORES = Suppliers.memoize(() -> List.of(OreConfiguration.target((RuleTest)new BlockMatchTest(Blocks.END_STONE), (BlockState)((Block)ModBlocks.END_EXP_ORE.get()).defaultBlockState())));

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        HolderGetter placedFeatures = context.lookup(Registries.PLACED_FEATURE);
        ModConfiguredFeatures.register(context, OVERWORLD_EXP_ORE_KEY, Feature.ORE, new OreConfiguration((List)OVERWORLD_EXP_ORES.get(), 7));
        ModConfiguredFeatures.register(context, NETHER_EXP_ORE_KEY, Feature.ORE, new OreConfiguration((List)NETHER_EXP_ORES.get(), 7));
        ModConfiguredFeatures.register(context, END_EXP_ORE_KEY, Feature.ORE, new OreConfiguration((List)END_EXP_ORES.get(), 7));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"expore", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

