package me.pepperbell.continuity.api.client;

import java.util.function.Function;

import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4730;
import net.minecraft.class_5819;

public interface QuadProcessor {
	ProcessingResult processQuad(MutableQuadView quad, class_1058 sprite, class_1920 blockView, class_2338 pos, class_2680 appearanceState, class_2680 state, class_5819 random, int pass, ProcessingContext context);

	interface ProcessingContext extends ProcessingDataProvider {
		QuadEmitter getExtraQuadEmitter();
	}

	enum ProcessingResult {
		NEXT_PROCESSOR,
		NEXT_PASS,
		STOP,
		DISCARD;
	}

	interface Factory<T extends CtmProperties> {
		QuadProcessor createProcessor(T properties, Function<class_4730, class_1058> textureGetter);
	}
}
