package me.pepperbell.continuity.client.config;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7919;

public class ContinuityConfigScreen extends class_437 {
	private final class_437 parent;
	private final ContinuityConfig config;

	private List<Value<?>> values;

	public ContinuityConfigScreen(class_437 parent, ContinuityConfig config) {
		super(class_2561.method_43471(getTranslationKey("title")));
		this.parent = parent;
		this.config = config;
	}

	@Override
	protected void method_25426() {
		Value<Boolean> connectedTextures = Value.of(config.connectedTextures, Value.Flag.RELOAD_WORLD_RENDERER);
		Value<Boolean> emissiveTextures = Value.of(config.emissiveTextures, Value.Flag.RELOAD_WORLD_RENDERER);
		Value<Boolean> customBlockLayers = Value.of(config.customBlockLayers, Value.Flag.RELOAD_WORLD_RENDERER);

		values = List.of(connectedTextures, emissiveTextures, customBlockLayers);

		method_37063(startBooleanValueButton(connectedTextures)
				.method_46434(field_22789 / 2 - 100 - 110, field_22790 / 2 - 10 - 12, 200, 20)
				.method_46431());
		method_37063(startBooleanValueButton(emissiveTextures)
				.method_46434(field_22789 / 2 - 100 + 110, field_22790 / 2 - 10 - 12, 200, 20)
				.method_46431());
		method_37063(startBooleanValueButton(customBlockLayers)
				.method_46434(field_22789 / 2 - 100 - 110, field_22790 / 2 - 10 + 12, 200, 20)
				.method_46431());

		method_37063(class_4185.method_46430(class_5244.field_24334,
				button -> {
					saveValues();
					method_25419();
				})
				.method_46434(field_22789 / 2 - 75 - 79, field_22790 - 40, 150, 20)
				.method_46431());
		method_37063(class_4185.method_46430(class_5244.field_24335, button -> method_25419())
				.method_46434(field_22789 / 2 - 75 + 79, field_22790 - 40, 150, 20)
				.method_46431());
	}

	@Override
	public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
		super.method_25394(context, mouseX, mouseY, delta);
		context.method_27534(field_22793, field_22785, field_22789 / 2, 30, 0xFFFFFF);
	}

	@Override
	public void method_25419() {
		field_22787.method_1507(parent);
	}

	private void saveValues() {
		EnumSet<Value.Flag> flags = EnumSet.noneOf(Value.Flag.class);

		for (Value<?> value : values) {
			if (value.isChanged()) {
				value.saveToOption();
				flags.addAll(value.getFlags());
			}
		}

		config.save();

		for (Value.Flag flag : flags) {
			flag.onSave();
		}
	}

	private static String getTranslationKey(String optionKey) {
		return "options.continuity." + optionKey;
	}

	private static String getTooltipKey(String translationKey) {
		return translationKey + ".tooltip";
	}

	private class_4185.class_7840 startBooleanValueButton(Value<Boolean> value) {
		String translationKey = getTranslationKey(value.getOption().getKey());
		class_2561 text = class_2561.method_43471(translationKey);
		class_2561 tooltipText = class_2561.method_43471(getTooltipKey(translationKey));

		return class_4185.method_46430(class_5244.method_32700(text, class_5244.method_36134(value.get())),
				button -> {
					boolean newValue = !value.get();
					value.set(newValue);
					class_2561 valueText = class_5244.method_36134(newValue);
					if (value.isChanged()) {
						valueText = valueText.method_27661().method_27694(style -> style.method_10982(true));
					}
					button.method_25355(class_5244.method_32700(text, valueText));
				})
				.method_46436(class_7919.method_47407(tooltipText));
	}

	private static class Value<T> {
		private final Option<T> option;
		private final Set<Flag> flags;
		private final T originalValue;
		private T value;

		public Value(Option<T> option, Set<Flag> flags) {
			this.option = option;
			this.flags = flags;
			originalValue = this.option.get();
			value = originalValue;
		}

		public static <T> Value<T> of(Option<T> option, Flag... flags) {
			EnumSet<Flag> flagSet = EnumSet.noneOf(Flag.class);
			Collections.addAll(flagSet, flags);
			return new Value<>(option, flagSet);
		}

		public Option<T> getOption() {
			return option;
		}

		public Set<Flag> getFlags() {
			return flags;
		}

		public T get() {
			return value;
		}

		public void set(T value) {
			this.value = value;
		}

		public boolean isChanged() {
			return !value.equals(originalValue);
		}

		public void saveToOption() {
			option.set(value);
		}

		public enum Flag {
			RELOAD_WORLD_RENDERER {
				@Override
				public void onSave() {
					class_310.method_1551().field_1769.method_3279();
				}
			};

			public abstract void onSave();
		}
	}
}
