package me.pepperbell.continuity.client.mixin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import me.pepperbell.continuity.client.resource.AtlasLoaderInitContext;
import me.pepperbell.continuity.client.resource.AtlasLoaderLoadContext;
import me.pepperbell.continuity.client.resource.EmissiveSuffixLoader;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7764;
import net.minecraft.class_7947;
import net.minecraft.class_7948;
import net.minecraft.class_7955;
import net.minecraft.class_8684;

@Mixin(class_7947.class)
abstract class AtlasLoaderMixin {
	@ModifyVariable(method = "<init>(Ljava/util/List;)V", at = @At(value = "LOAD", ordinal = 0), argsOnly = true, ordinal = 0)
	private List<class_7948> continuity$modifySources(List<class_7948> sources) {
		AtlasLoaderInitContext context = AtlasLoaderInitContext.THREAD_LOCAL.get();
		if (context != null) {
			Set<class_2960> extraIds = context.getExtraIds();
			if (extraIds != null && !extraIds.isEmpty()) {
				List<class_7948> extraSources = new ObjectArrayList<>();
				for (class_2960 extraId : extraIds) {
					extraSources.add(new class_7955(extraId, Optional.empty()));
				}

				if (sources instanceof ArrayList) {
					sources.addAll(0, extraSources);
				} else {
					List<class_7948> mutableSources = new ArrayList<>(extraSources);
					mutableSources.addAll(sources);
					return mutableSources;
				}
			}
		}
		return sources;
	}

	@Inject(method = "loadSources(Lnet/minecraft/resource/ResourceManager;)Ljava/util/List;", at = @At(value = "INVOKE", target = "Lcom/google/common/collect/ImmutableList;builder()Lcom/google/common/collect/ImmutableList$Builder;", remap = false), locals = LocalCapture.CAPTURE_FAILHARD)
	private void continuity$afterLoadSources(class_3300 resourceManager, CallbackInfoReturnable<List<Function<class_8684, class_7764>>> cir, Map<class_2960, class_7948.class_7950> suppliers) {
		AtlasLoaderLoadContext context = AtlasLoaderLoadContext.THREAD_LOCAL.get();
		if (context != null) {
			String emissiveSuffix = EmissiveSuffixLoader.getEmissiveSuffix();
			if (emissiveSuffix != null) {
				Map<class_2960, class_7948.class_7950> emissiveSuppliers = new Object2ObjectOpenHashMap<>();
				Map<class_2960, class_2960> emissiveIdMap = new Object2ObjectOpenHashMap<>();
				suppliers.forEach((id, supplier) -> {
					if (!id.method_12832().endsWith(emissiveSuffix)) {
						class_2960 emissiveId = id.method_45136(id.method_12832() + emissiveSuffix);
						if (!suppliers.containsKey(emissiveId)) {
							class_2960 emissiveLocation = emissiveId.method_45136("textures/" + emissiveId.method_12832() + ".png");
							Optional<class_3298> optionalResource = resourceManager.method_14486(emissiveLocation);
							if (optionalResource.isPresent()) {
								class_3298 resource = optionalResource.get();
								emissiveSuppliers.put(emissiveId, opener -> opener.loadSprite(emissiveId, resource));
								emissiveIdMap.put(id, emissiveId);
							}
						} else {
							emissiveIdMap.put(id, emissiveId);
						}
					}
				});
				suppliers.putAll(emissiveSuppliers);
				context.setEmissiveIdMap(emissiveIdMap);
			} else {
				context.setEmissiveIdMap(Collections.emptyMap());
			}
		}
	}
}
