package me.pepperbell.continuity.client.mixin;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import com.llamalad7.mixinextras.sugar.Local;

import me.pepperbell.continuity.client.resource.CtmResourceReloader;
import me.pepperbell.continuity.client.resource.EmissiveSuffixLoader;
import me.pepperbell.continuity.client.resource.ModelWrappingHandler;
import me.pepperbell.continuity.client.resource.SpriteLoaderLoadContext;
import me.pepperbell.continuity.client.resource.SpriteLoaderLoadContextImpl;
import net.minecraft.class_10725;
import net.minecraft.class_11697;
import net.minecraft.class_2960;
import net.minecraft.class_3302;

@Mixin(class_11697.class)
abstract class AtlasManagerMixin {
	@Inject(method = "prepareSharedState(Lnet/minecraft/resource/ResourceReloader$Store;)V", at = @At("RETURN"))
	private void continuity$onReturnPrepareSharedState(class_3302.class_11558 store, CallbackInfo ci) {
		store.method_72363(ModelWrappingHandler.WRAP_EMISSIVE_FUTURE_KEY, new CompletableFuture<>());
	}

	@Inject(method = "reload(Lnet/minecraft/resource/ResourceReloader$Store;Ljava/util/concurrent/Executor;Lnet/minecraft/resource/ResourceReloader$Synchronizer;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;", at = @At(value = "INVOKE", target = "Lnet/minecraft/resource/ResourceReloader$Store;getResourceManager()Lnet/minecraft/resource/ResourceManager;"))
	private void continuity$onHeadReload(class_3302.class_11558 store, Executor prepareExecutor, class_3302.class_4045 synchronizer, Executor applyExecutor, CallbackInfoReturnable<CompletableFuture<Void>> cir, @Local class_11697.class_11700 stitch) {
		EmissiveSuffixLoader.load(store.method_72361());
		CompletableFuture<Map<class_2960, Set<class_2960>>> allExtraIdsFuture = store.method_72362(CtmResourceReloader.ALL_EXTRA_IDS_FUTURE_KEY);
		CompletableFuture<Boolean> wrapEmissiveFuture = store.method_72362(ModelWrappingHandler.WRAP_EMISSIVE_FUTURE_KEY);

		// This shouldn't be necessary, but it prevents a deadlock if for whatever reason the future isn't completed
		// before this.
		stitch.method_73038(class_10725.field_56382).whenComplete((stitchResult, t) -> {
			wrapEmissiveFuture.complete(false);
		});

		SpriteLoaderLoadContext.THREAD_LOCAL.set(new SpriteLoaderLoadContextImpl(allExtraIdsFuture, wrapEmissiveFuture));
	}

	@Inject(method = "reload(Lnet/minecraft/resource/ResourceReloader$Store;Ljava/util/concurrent/Executor;Lnet/minecraft/resource/ResourceReloader$Synchronizer;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;", at = @At("RETURN"))
	private void continuity$onReturnReload(CallbackInfoReturnable<CompletableFuture<Void>> cir) {
		SpriteLoaderLoadContext.THREAD_LOCAL.set(null);
	}
}
