package me.pepperbell.continuity.client.mixin;

import java.util.List;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import me.pepperbell.continuity.client.resource.ResourceRedirectHandler;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_6861;

@Mixin(class_6861.class)
abstract class LifecycledResourceManagerImplMixin {
	@Unique
	private boolean continuity$useRedirects = false;

	@Inject(method = "<init>(Lnet/minecraft/resource/ResourceType;Ljava/util/List;)V", at = @At("TAIL"))
	private void continuity$onTailInit(class_3264 type, List<class_3262> packs, CallbackInfo ci) {
		continuity$useRedirects = type == class_3264.field_14188;
	}

	@ModifyVariable(method = "getResource(Lnet/minecraft/util/Identifier;)Ljava/util/Optional;", at = @At("HEAD"), argsOnly = true)
	private class_2960 continuity$redirectGetResourceId(class_2960 id) {
		if (continuity$useRedirects) {
			return ResourceRedirectHandler.redirect(id);
		}
		return id;
	}

	@ModifyVariable(method = "getAllResources(Lnet/minecraft/util/Identifier;)Ljava/util/List;", at = @At("HEAD"), argsOnly = true)
	private class_2960 continuity$redirectGetAllResourcesId(class_2960 id) {
		if (continuity$useRedirects) {
			return ResourceRedirectHandler.redirect(id);
		}
		return id;
	}
}
