package me.pepperbell.continuity.client.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import me.pepperbell.continuity.client.config.ContinuityConfig;
import me.pepperbell.continuity.client.resource.CustomBlockLayers;
import net.fabricmc.fabric.api.renderer.v1.render.RenderLayerHelper;
import net.minecraft.class_11515;
import net.minecraft.class_1921;
import net.minecraft.class_2680;
import net.minecraft.class_4696;

@Mixin(class_4696.class)
abstract class RenderLayersMixin {
	@Inject(method = "getBlockLayer(Lnet/minecraft/block/BlockState;)Lnet/minecraft/client/render/BlockRenderLayer;", at = @At("HEAD"), cancellable = true)
	private static void continuity$onHeadGetBlockLayer(class_2680 state, CallbackInfoReturnable<class_11515> cir) {
		if (!CustomBlockLayers.isEmpty() && ContinuityConfig.INSTANCE.customBlockLayers.get()) {
			class_11515 layer = CustomBlockLayers.getLayer(state);
			if (layer != null) {
				cir.setReturnValue(layer);
			}
		}
	}

	@Inject(method = "getMovingBlockLayer(Lnet/minecraft/block/BlockState;)Lnet/minecraft/client/render/RenderLayer;", at = @At("HEAD"), cancellable = true)
	private static void continuity$onHeadGetMovingBlockLayer(class_2680 state, CallbackInfoReturnable<class_1921> cir) {
		if (!CustomBlockLayers.isEmpty() && ContinuityConfig.INSTANCE.customBlockLayers.get()) {
			class_11515 layer = CustomBlockLayers.getLayer(state);
			if (layer != null) {
				cir.setReturnValue(RenderLayerHelper.getMovingBlockLayer(layer));
			}
		}
	}
}
