package me.pepperbell.continuity.client.processor;

import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

import org.jetbrains.annotations.Nullable;

import me.pepperbell.continuity.api.client.CachingPredicates;
import me.pepperbell.continuity.client.properties.BaseCtmProperties;
import net.minecraft.class_1058;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4730;

public class BaseCachingPredicates implements CachingPredicates {
	@Nullable
	protected Set<class_2960> spriteIdSet;
	@Nullable
	protected Predicate<class_2680> blockStatePredicate;
	protected boolean isValidForMultipass;

	public BaseCachingPredicates(@Nullable Set<class_2960> spriteIdSet, @Nullable Predicate<class_2680> blockStatePredicate, boolean isValidForMultipass) {
		this.spriteIdSet = spriteIdSet;
		this.blockStatePredicate = blockStatePredicate;
		this.isValidForMultipass = isValidForMultipass;
	}

	@Override
	public boolean affectsSprites() {
		return spriteIdSet != null;
	}

	@Override
	public boolean affectsSprite(class_1058 sprite) {
		if (spriteIdSet != null) {
			return spriteIdSet.contains(sprite.method_45851().method_45816());
		}
		return false;
	}

	@Override
	public boolean affectsBlockStates() {
		return blockStatePredicate != null;
	}

	@Override
	public boolean affectsBlockState(class_2680 state) {
		if (blockStatePredicate != null) {
			return blockStatePredicate.test(state);
		}
		return false;
	}

	@Override
	public boolean isValidForMultipass() {
		return isValidForMultipass;
	}

	public static class Factory<T extends BaseCtmProperties> implements CachingPredicates.Factory<T> {
		protected boolean isValidForMultipass;

		public Factory(boolean isValidForMultipass) {
			this.isValidForMultipass = isValidForMultipass;
		}

		@Override
		public CachingPredicates createPredicates(T properties, Function<class_4730, class_1058> textureGetter) {
			return new BaseCachingPredicates(properties.getMatchTilesSet(), properties.getMatchBlocksPredicate(), isValidForMultipass);
		}
	}
}
