package me.pepperbell.continuity.client.processor;

import org.apache.commons.lang3.ArrayUtils;

import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.class_2350;
import net.minecraft.class_2680;

public final class DirectionMaps {
	public static final class_2350[][][] DIRECTION_MAPS = new class_2350[6][8][];
	static {
		for (class_2350 face : class_2350.values()) {
			class_2350 textureUp;
			if (face == class_2350.field_11036) {
				textureUp = class_2350.field_11043;
			} else if (face == class_2350.field_11033) {
				textureUp = class_2350.field_11035;
			} else {
				textureUp = class_2350.field_11036;
			}

			class_2350 textureLeft;
			if (face.method_10171() == class_2350.class_2352.field_11060) {
				textureLeft = textureUp.method_35833(face.method_10166());
			} else {
				textureLeft = textureUp.method_35834(face.method_10166());
			}

			class_2350[][] map = DIRECTION_MAPS[face.ordinal()];

			map[0] = new class_2350[] { textureLeft, textureUp.method_10153(), textureLeft.method_10153(), textureUp }; // l d r u
			map[1] = map[0].clone(); // d r u l
			ArrayUtils.shift(map[1], -1);
			map[2] = map[1].clone(); // r u l d
			ArrayUtils.shift(map[2], -1);
			map[3] = map[2].clone(); // u l d r
			ArrayUtils.shift(map[3], -1);

			map[4] = map[0].clone(); // r d l u
			ArrayUtils.swap(map[4], 0, 2);
			map[5] = map[1].clone(); // u r d l
			ArrayUtils.swap(map[5], 0, 2);
			map[6] = map[2].clone(); // l u r d
			ArrayUtils.swap(map[6], 0, 2);
			map[7] = map[3].clone(); // d l u r
			ArrayUtils.swap(map[7], 0, 2);
		}
	}

	public static class_2350[][] getMap(class_2350 direction) {
		return DIRECTION_MAPS[direction.ordinal()];
	}

	public static class_2350[] getDirections(OrientationMode orientationMode, QuadView quad, class_2680 state) {
		return getMap(quad.lightFace())[orientationMode.getOrientation(quad, state)];
	}
}
