package me.pepperbell.continuity.client.processor;

import me.pepperbell.continuity.client.util.QuadUtil;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;

public enum OrientationMode {
	NONE,
	STATE_AXIS,
	TEXTURE;

	public static final int[][] AXIS_ORIENTATIONS = new int[][] {
			{ 3, 3, 1, 3, 0, 2 },
			{ 0, 0, 0, 0, 0, 0 },
			{ 2, 0, 2, 0, 1, 3 }
	};

	public int getOrientation(QuadView quad, class_2680 state) {
		return switch (this) {
			case NONE -> 0;
			case STATE_AXIS -> {
				if (state.method_28498(class_2741.field_12496)) {
					class_2350.class_2351 axis = state.method_11654(class_2741.field_12496);
					yield AXIS_ORIENTATIONS[axis.ordinal()][quad.lightFace().ordinal()];
				} else {
					yield 0;
				}
			}
			case TEXTURE -> QuadUtil.getTextureOrientation(quad);
		};
	}
}
