package me.pepperbell.continuity.client.properties;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.Predicate;

import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.processor.OrientationMode;
import me.pepperbell.continuity.client.processor.Symmetry;
import me.pepperbell.continuity.client.resource.ResourceRedirectHandler;
import net.minecraft.class_151;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public final class PropertiesParsingHelper {
	public static final Predicate<class_2680> EMPTY_BLOCK_STATE_PREDICATE = state -> false;

	@Nullable
	public static Set<class_2960> parseMatchTiles(Properties properties, String propertyKey, class_2960 fileLocation, String packId) {
		String matchTilesStr = properties.getProperty(propertyKey);
		if (matchTilesStr == null) {
			return null;
		}

		String[] matchTileStrs = matchTilesStr.trim().split(" ");
		if (matchTileStrs.length != 0) {
			String basePath = FilenameUtils.getPath(fileLocation.method_12832());
			ObjectOpenHashSet<class_2960> set = new ObjectOpenHashSet<>();

			for (int i = 0; i < matchTileStrs.length; i++) {
				String matchTileStr = matchTileStrs[i];
				if (matchTileStr.isEmpty()) {
					continue;
				}

				String[] parts = matchTileStr.split(":", 2);
				if (parts.length != 0) {
					String namespace;
					String path;
					if (parts.length > 1) {
						namespace = parts[0];
						path = parts[1];
					} else {
						namespace = null;
						path = parts[0];
					}

					if (path.endsWith(".png")) {
						path = path.substring(0, path.length() - 4);
					}

					if (namespace == null) {
						if (path.startsWith("assets/minecraft/")) {
							path = path.substring(17);
						} else if (path.startsWith("./")) {
							path = basePath + path.substring(2);
						} else if (path.startsWith("~/")) {
							path = "optifine/" + path.substring(2);
						} else if (path.startsWith("/")) {
							path = "optifine/" + path.substring(1);
						}
					}

					if (path.startsWith("textures/")) {
						path = path.substring(9);
					} else if (path.startsWith("optifine/")) {
						path = ResourceRedirectHandler.SPRITE_PATH_START + path.substring(9);
						if (namespace == null) {
							namespace = fileLocation.method_12836();
						}
					} else if (!path.contains("/")) {
						path = "block/" + path;
					}

					if (namespace == null) {
						namespace = class_2960.field_33381;
					}

					try {
						set.add(class_2960.method_60655(namespace, path));
					} catch (class_151 e) {
						ContinuityClient.LOGGER.warn("Invalid '" + propertyKey + "' element '" + matchTileStr + "' at index " + i + " in file '" + fileLocation + "' in pack '" + packId + "'", e);
					}
				} else {
					ContinuityClient.LOGGER.warn("Invalid '" + propertyKey + "' element '" + matchTileStr + "' at index " + i + " in file '" + fileLocation + "' in pack '" + packId + "'");
				}
			}

			set.trim();
			return set;
		}
		return Collections.emptySet();
	}

	@Nullable
	public static Predicate<class_2680> parseBlockStates(Properties properties, String propertyKey, class_2960 fileLocation, String packId) {
		String blockStatesStr = properties.getProperty(propertyKey);
		if (blockStatesStr == null) {
			return null;
		}

		String[] blockStateStrs = blockStatesStr.trim().split(" ");
		if (blockStateStrs.length != 0) {
			ReferenceOpenHashSet<class_2248> blockSet = new ReferenceOpenHashSet<>();
			Reference2ObjectOpenHashMap<class_2248, Object2ObjectOpenHashMap<class_2769<?>, ObjectOpenHashSet<Comparable<?>>>> propertyMaps = new Reference2ObjectOpenHashMap<>();

			Block:
			for (int i = 0; i < blockStateStrs.length; i++) {
				String blockStateStr = blockStateStrs[i].trim();
				if (blockStateStr.isEmpty()) {
					continue;
				}

				String[] parts = blockStateStr.split(":");
				if (parts.length != 0) {
					class_2960 blockId;
					int startIndex;
					try {
						if (parts.length == 1 || parts[1].contains("=")) {
							blockId = class_2960.method_60656(parts[0]);
							startIndex = 1;
						} else {
							blockId = class_2960.method_60655(parts[0], parts[1]);
							startIndex = 2;
						}
					} catch (class_151 e) {
						ContinuityClient.LOGGER.warn("Invalid '" + propertyKey + "' element '" + blockStateStr + "' at index " + i + " in file '" + fileLocation + "' in pack '" + packId + "'", e);
						continue;
					}

					if (class_7923.field_41175.method_10250(blockId)) {
						class_2248 block = class_7923.field_41175.method_63535(blockId);
						if (!blockSet.contains(block)) {
							if (parts.length > startIndex) {
								Object2ObjectOpenHashMap<class_2769<?>, ObjectOpenHashSet<Comparable<?>>> propertyMap = new Object2ObjectOpenHashMap<>();

								for (int j = startIndex; j < parts.length; j++) {
									String part = parts[j];
									if (!part.isEmpty()) {
										String[] propertyParts = part.split("=", 2);
										if (propertyParts.length == 2) {
											String propertyName = propertyParts[0];
											class_2769<?> property = block.method_9595().method_11663(propertyName);
											if (property != null) {
												String propertyValuesStr = propertyParts[1];
												String[] propertyValueStrs = propertyValuesStr.split(",");
												if (propertyValueStrs.length != 0) {
													ObjectOpenHashSet<Comparable<?>> valueSet = propertyMap.computeIfAbsent(property, p -> new ObjectOpenHashSet<>(Hash.DEFAULT_INITIAL_SIZE, Hash.VERY_FAST_LOAD_FACTOR));

													for (String propertyValueStr : propertyValueStrs) {
														Optional<? extends Comparable<?>> optionalValue = property.method_11900(propertyValueStr);
														if (optionalValue.isPresent()) {
															valueSet.add(optionalValue.get());
														} else {
															ContinuityClient.LOGGER.warn("Invalid block property value '" + propertyValueStr + "' for property '" + propertyName + "' for block '" + blockId + "' in '" + propertyKey + "' element '" + blockStateStr + "' at index " + i + " in file '" + fileLocation + "' in pack '" + packId + "'");
															continue Block;
														}
													}
												} else {
													ContinuityClient.LOGGER.warn("Invalid block property definition for block '" + blockId + "' in '" + propertyKey + "' element '" + blockStateStr + "' at index " + i + " in file '" + fileLocation + "' in pack '" + packId + "'");
													continue Block;
												}
											} else {
												ContinuityClient.LOGGER.warn("Unknown block property '" + propertyName + "' for block '" + blockId + "' in '" + propertyKey + "' element '" + blockStateStr + "' at index " + i + " in file '" + fileLocation + "' in pack '" + packId + "'");
												continue Block;
											}
										} else {
											ContinuityClient.LOGGER.warn("Invalid block property definition for block '" + blockId + "' in '" + propertyKey + "' element '" + blockStateStr + "' at index " + i + " in file '" + fileLocation + "' in pack '" + packId + "'");
											continue Block;
										}
									}
								}

								if (!propertyMap.isEmpty()) {
									Object2ObjectOpenHashMap<class_2769<?>, ObjectOpenHashSet<Comparable<?>>> existingPropertyMap = propertyMaps.get(block);
									if (existingPropertyMap == null) {
										propertyMaps.put(block, propertyMap);
									} else {
										propertyMap.forEach((property, valueSet) -> {
											ObjectOpenHashSet<Comparable<?>> existingValueSet = existingPropertyMap.get(property);
											if (existingValueSet == null) {
												existingPropertyMap.put(property, valueSet);
											} else {
												existingValueSet.addAll(valueSet);
											}
										});
									}
								}
							} else {
								blockSet.add(block);
								propertyMaps.remove(block);
							}
						}
					} else {
						ContinuityClient.LOGGER.warn("Unknown block '" + blockId + "' in '" + propertyKey + "' element '" + blockStateStr + "' at index " + i + " in file '" + fileLocation + "' in pack '" + packId + "'");
					}
				} else {
					ContinuityClient.LOGGER.warn("Invalid '" + propertyKey + "' element '" + blockStateStr + "' at index " + i + " in file '" + fileLocation + "' in pack '" + packId + "'");
				}
			}

			if (!blockSet.isEmpty() || !propertyMaps.isEmpty()) {
				if (propertyMaps.isEmpty()) {
					if (blockSet.size() == 1) {
						class_2248 block = blockSet.toArray(class_2248[]::new)[0];
						return state -> state.method_26204() == block;
					} else {
						blockSet.trim();
						return state -> blockSet.contains(state.method_26204());
					}
				} else {
					Reference2ReferenceOpenHashMap<class_2248, Predicate<class_2680>> predicateMap = new Reference2ReferenceOpenHashMap<>();
					blockSet.forEach(block -> {
						predicateMap.put(block, state -> true);
					});
					propertyMaps.forEach((block, propertyMap) -> {
						Map.Entry<class_2769<?>, ObjectOpenHashSet<Comparable<?>>>[] entryArray = propertyMap.entrySet().toArray((IntFunction<Map.Entry<class_2769<?>, ObjectOpenHashSet<Comparable<?>>>[]>) Map.Entry[]::new);
						for (Map.Entry<class_2769<?>, ObjectOpenHashSet<Comparable<?>>> entry : entryArray) {
							entry.getValue().trim();
						}

						predicateMap.put(block, state -> {
							Map<class_2769<?>, Comparable<?>> targetValueMap = state.method_11656();
							for (Map.Entry<class_2769<?>, ObjectOpenHashSet<Comparable<?>>> entry : entryArray) {
								Comparable<?> targetValue = targetValueMap.get(entry.getKey());
								if (targetValue != null) {
									if (!entry.getValue().contains(targetValue)) {
										return false;
									}
								}
							}
							return true;
						});
					});

					return state -> {
						Predicate<class_2680> predicate = predicateMap.get(state.method_26204());
						return predicate != null && predicate.test(state);
					};
				}
			}
		}
		return EMPTY_BLOCK_STATE_PREDICATE;
	}

	@Nullable
	public static Symmetry parseSymmetry(Properties properties, String propertyKey, class_2960 fileLocation, String packId) {
		String symmetryStr = properties.getProperty(propertyKey);
		if (symmetryStr == null) {
			return null;
		}

		try {
			return Symmetry.valueOf(symmetryStr.trim().toUpperCase(Locale.ROOT));
		} catch (IllegalArgumentException e) {
			ContinuityClient.LOGGER.warn("Unknown '" + propertyKey + "' value '" + symmetryStr + "' in file '" + fileLocation + "' in pack '" + packId + "'");
		}
		return null;
	}

	@Nullable
	public static OrientationMode parseOrientationMode(Properties properties, String propertyKey, class_2960 fileLocation, String packId) {
		String orientationModeStr = properties.getProperty(propertyKey);
		if (orientationModeStr == null) {
			return null;
		}

		try {
			return OrientationMode.valueOf(orientationModeStr.trim().toUpperCase(Locale.ROOT));
		} catch (IllegalArgumentException e) {
			ContinuityClient.LOGGER.warn("Unknown '" + propertyKey + "' value '" + orientationModeStr + "' in file '" + fileLocation + "' in pack '" + packId + "'");
		}
		return null;
	}

	public static boolean parseOptifineOnly(Properties properties, class_2960 fileLocation) {
		if (!fileLocation.method_12836().equals(class_2960.field_33381)) {
			return false;
		}

		String optifineOnlyStr = properties.getProperty("optifineOnly");
		if (optifineOnlyStr == null) {
			return false;
		}

		return Boolean.parseBoolean(optifineOnlyStr.trim());
	}
}
