package me.pepperbell.continuity.client.resource;

import java.io.InputStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;

import org.jetbrains.annotations.NotNull;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import me.pepperbell.continuity.api.client.CachingPredicates;
import me.pepperbell.continuity.api.client.CtmLoader;
import me.pepperbell.continuity.api.client.CtmLoaderRegistry;
import me.pepperbell.continuity.api.client.CtmProperties;
import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.model.QuadProcessors;
import me.pepperbell.continuity.client.util.biome.BiomeHolderManager;
import net.minecraft.class_1058;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_4730;

public class CtmPropertiesLoader {
	private final class_3300 resourceManager;
	private final List<LoadingContainer<?>> containers = new ObjectArrayList<>();
	private final Map<class_2960, Set<class_2960>> textureDependencies = new Object2ObjectOpenHashMap<>();

	private CtmPropertiesLoader(class_3300 resourceManager) {
		this.resourceManager = resourceManager;
	}

	public static LoadingResult loadAllWithState(class_3300 resourceManager) {
		// TODO: move these to the very beginning of resource reload
		BiomeHolderManager.clearCache();

		LoadingResult result = loadAll(resourceManager);

		// TODO: move these to the very end of resource reload
		BiomeHolderManager.refreshHolders();

		return result;
	}

	public static LoadingResult loadAll(class_3300 resourceManager) {
		return new CtmPropertiesLoader(resourceManager).loadAll();
	}

	private LoadingResult loadAll() {
		int packPriority = 0;
		Iterator<class_3262> iterator = resourceManager.method_29213().iterator();
		while (iterator.hasNext()) {
			class_3262 pack = iterator.next();
			loadAll(pack, packPriority);
			packPriority++;
		}

		containers.sort(Comparator.reverseOrder());

		return new LoadingResult(containers, textureDependencies);
	}

	private void loadAll(class_3262 pack, int packPriority) {
		for (String namespace : pack.method_14406(class_3264.field_14188)) {
			pack.method_14408(class_3264.field_14188, namespace, "optifine/ctm", (resourceId, inputSupplier) -> {
				if (resourceId.method_12832().endsWith(".properties")) {
					try (InputStream stream = inputSupplier.get()) {
						Properties properties = new Properties();
						properties.load(stream);
						load(properties, resourceId, pack, packPriority);
					} catch (Exception e) {
						ContinuityClient.LOGGER.error("Failed to load CTM properties from file '" + resourceId + "' in pack '" + pack.method_14409() + "'", e);
					}
				}
			});
		}
	}

	private void load(Properties properties, class_2960 resourceId, class_3262 pack, int packPriority) {
		String method = properties.getProperty("method", "ctm").trim();
		CtmLoader<?> loader = CtmLoaderRegistry.get().getLoader(method);
		if (loader != null) {
			load(loader, properties, resourceId, pack, packPriority, method);
		} else {
			ContinuityClient.LOGGER.error("Unknown 'method' value '" + method + "' in file '" + resourceId + "' in pack '" + pack.method_14409() + "'");
		}
	}

	private <T extends CtmProperties> void load(CtmLoader<T> loader, Properties properties, class_2960 resourceId, class_3262 pack, int packPriority, String method) {
		T ctmProperties = loader.getPropertiesFactory().createProperties(properties, resourceId, pack, packPriority, resourceManager, method);
		if (ctmProperties != null) {
			LoadingContainer<T> container = new LoadingContainer<>(loader, ctmProperties);
			containers.add(container);
			for (class_4730 spriteId : ctmProperties.getTextureDependencies()) {
				Set<class_2960> atlasTextureDependencies = textureDependencies.computeIfAbsent(spriteId.method_24144(), id -> new ObjectOpenHashSet<>());
				atlasTextureDependencies.add(spriteId.method_24147());
			}
		}
	}

	private record LoadingContainer<T extends CtmProperties>(CtmLoader<T> loader, T properties) implements Comparable<LoadingContainer<?>> {
		public QuadProcessors.ProcessorHolder toProcessorHolder(Function<class_4730, class_1058> textureGetter) {
			QuadProcessor processor = loader.getProcessorFactory().createProcessor(properties, textureGetter);
			CachingPredicates predicates = loader.getPredicatesFactory().createPredicates(properties, textureGetter);
			return new QuadProcessors.ProcessorHolder(processor, predicates);
		}

		@Override
		public int compareTo(@NotNull LoadingContainer<?> o) {
			return properties.compareTo(o.properties);
		}
	}

	public static class LoadingResult {
		private final List<LoadingContainer<?>> containers;
		private final Map<class_2960, Set<class_2960>> textureDependencies;

		private LoadingResult(List<LoadingContainer<?>> containers, Map<class_2960, Set<class_2960>> textureDependencies) {
			this.containers = containers;
			this.textureDependencies = textureDependencies;
		}

		public List<QuadProcessors.ProcessorHolder> createProcessorHolders(Function<class_4730, class_1058> textureGetter) {
			List<QuadProcessors.ProcessorHolder> processorHolders = new ObjectArrayList<>();
			for (LoadingContainer<?> container : containers) {
				processorHolders.add(container.toProcessorHolder(textureGetter));
			}
			return processorHolders;
		}

		public Map<class_2960, Set<class_2960>> getTextureDependencies() {
			return textureDependencies;
		}
	}
}
