package me.pepperbell.continuity.client.resource;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.model.QuadProcessors;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_10725;
import net.minecraft.class_11697;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_7766;

public class CtmResourceReloader implements class_3302 {
	public static final class_11559<CompletableFuture<Map<class_2960, Set<class_2960>>>> ALL_EXTRA_IDS_FUTURE_KEY = new class_11559<>();

	public static final class_2960 ID = ContinuityClient.asId("ctm");
	public static final CtmResourceReloader INSTANCE = new CtmResourceReloader();

	@Override
	public void prepareSharedState(class_11558 store) {
		store.method_72363(ALL_EXTRA_IDS_FUTURE_KEY, new CompletableFuture<>());
		store.method_72363(ModelWrappingHandler.WRAP_CTM_FUTURE_KEY, new CompletableFuture<>());
	}

	@Override
	public CompletableFuture<Void> method_25931(class_11558 store, Executor prepareExecutor, class_4045 synchronizer, Executor applyExecutor) {
		class_3300 resourceManager = store.method_72361();
		CompletableFuture<Map<class_2960, Set<class_2960>>> allExtraIdsFuture = store.method_72362(ALL_EXTRA_IDS_FUTURE_KEY);
		CompletableFuture<Boolean> wrapCtmFuture = store.method_72362(ModelWrappingHandler.WRAP_CTM_FUTURE_KEY);
		CompletableFuture<CtmPropertiesLoader.LoadingResult> ctmLoadingResultFuture = CompletableFuture.supplyAsync(() -> CtmPropertiesLoader.loadAllWithState(resourceManager), prepareExecutor).whenComplete((ctmLoadingResult, t) -> {
			if (ctmLoadingResult != null) {
				allExtraIdsFuture.complete(ctmLoadingResult.getTextureDependencies());
			} else {
				allExtraIdsFuture.completeExceptionally(t);
			}
		});
		CompletableFuture<class_7766.class_7767> blockAtlasStitchResultFuture = store.method_72362(class_11697.field_61861).method_73038(class_10725.field_56382);

		CompletableFuture<List<QuadProcessors.ProcessorHolder>> future = CompletableFuture.allOf(ctmLoadingResultFuture, blockAtlasStitchResultFuture).thenApplyAsync(v -> {
			CtmPropertiesLoader.LoadingResult ctmLoadingResult = ctmLoadingResultFuture.join();
			class_7766.class_7767 blockAtlasStitchResult = blockAtlasStitchResultFuture.join();

			return ctmLoadingResult.createProcessorHolders(spriteId -> {
				if (spriteId.method_24144().equals(class_1059.field_5275)) {
					class_1058 sprite = blockAtlasStitchResult.method_73022(spriteId.method_24147());
					if (sprite != null) {
						return sprite;
					}
				}
				return blockAtlasStitchResult.comp_1043();
			});
		}, prepareExecutor).whenComplete((processorHolders, t) -> {
			if (processorHolders != null) {
				wrapCtmFuture.complete(!processorHolders.isEmpty());
			} else {
				wrapCtmFuture.completeExceptionally(t);
			}
		});

		Objects.requireNonNull(synchronizer);
		return future.thenCompose(synchronizer::method_18352).thenAcceptAsync(this::apply, applyExecutor);
	}

	private void apply(List<QuadProcessors.ProcessorHolder> processorHolders) {
		QuadProcessors.reload(processorHolders);
	}
}
