package me.pepperbell.continuity.client.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;

import org.jetbrains.annotations.Nullable;

import me.pepperbell.continuity.client.ContinuityClient;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public final class EmissiveSuffixLoader {
	public static final class_2960 LOCATION = class_2960.method_60656("optifine/emissive.properties");

	private static String emissiveSuffix;

	@Nullable
	public static String getEmissiveSuffix() {
		return emissiveSuffix;
	}

	public static void load(class_3300 manager) {
		emissiveSuffix = null;

		Optional<class_3298> optionalResource = manager.method_14486(LOCATION);
		if (optionalResource.isPresent()) {
			class_3298 resource = optionalResource.get();
			try (InputStream inputStream = resource.method_14482()) {
				Properties properties = new Properties();
				properties.load(inputStream);
				emissiveSuffix = properties.getProperty("suffix.emissive");
			} catch (IOException e) {
				ContinuityClient.LOGGER.error("Failed to load emissive suffix from file '" + LOCATION + "'", e);
			}
		}
	}
}
