package me.pepperbell.continuity.client.resource;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public interface SpriteLoaderLoadContext {
	ThreadLocal<SpriteLoaderLoadContext> THREAD_LOCAL = new ThreadLocal<>();

	CompletableFuture<@Nullable Set<class_2960>> getExtraIdsFuture(class_2960 atlasId);

	@Nullable
	EmissiveControl getEmissiveControl(class_2960 atlasId);

	interface EmissiveControl {
		@Nullable
		Map<class_2960, class_2960> getEmissiveIdMap();

		void setEmissiveIdMap(Map<class_2960, class_2960> emissiveIdMap);

		void setHasEmissives(boolean hasEmissives);
	}
}
