package me.pepperbell.continuity.client.util.biome;

import java.util.Map;

import org.jetbrains.annotations.Nullable;

import me.pepperbell.continuity.client.ContinuityClient;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public final class BiomeHolder {
	private final class_2960 id;
	@Nullable
	private class_1959 biome;

	BiomeHolder(class_2960 id) {
		this.id = id;
	}

	public class_2960 getId() {
		return id;
	}

	@Nullable
	public class_1959 getBiome() {
		return biome;
	}

	void refresh(class_2378<class_1959> biomeRegistry, Map<class_2960, class_2960> compactIdMap) {
		class_2960 id = compactIdMap.get(this.id);
		if (id == null) {
			id = this.id;
		}
		if (biomeRegistry.method_10250(id)) {
			biome = biomeRegistry.method_63535(id);
		} else {
			ContinuityClient.LOGGER.warn("Unknown biome '" + this.id + "'");
		}
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) return true;
		if (o == null || getClass() != o.getClass()) return false;
		BiomeHolder that = (BiomeHolder) o;
		return id.equals(that.id);
	}

	@Override
	public int hashCode() {
		return id.hashCode();
	}
}
