package me.pepperbell.continuity.client.util.biome;

import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1959;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;

public class BiomeSetPredicate implements Predicate<class_1959> {
	private final Set<BiomeHolder> holders;
	private Set<class_1959> biomes = Collections.emptySet();

	public BiomeSetPredicate(Set<BiomeHolder> holders) {
		this.holders = holders;
		BiomeHolderManager.addRefreshCallback(this::refresh);
	}

	@Override
	public boolean test(class_1959 biome) {
		return biomes.contains(biome);
	}

	private void refresh() {
		Set<class_1959> biomes = new ObjectOpenHashSet<>(Hash.DEFAULT_INITIAL_SIZE, Hash.FAST_LOAD_FACTOR);
		for (BiomeHolder holder : holders) {
			class_1959 biome = holder.getBiome();
			if (biome != null) {
				biomes.add(biome);
			}
		}
		this.biomes = biomes;
	}
}
