/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.model;

import java.util.function.Function;
import java.util.function.Predicate;
import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.client.config.ContinuityConfig;
import me.pepperbell.continuity.client.model.ModelObjectsContainer;
import me.pepperbell.continuity.client.model.QuadProcessors;
import me.pepperbell.continuity.client.util.RenderUtil;
import me.pepperbell.continuity.impl.client.ProcessingContextImpl;
import net.fabricmc.fabric.api.client.model.loading.v1.wrapper.WrapperBlockStateModel;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadTransform;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class CtmBlockStateModel
extends WrapperBlockStateModel {
    public static final int PASSES = 4;
    protected final class_2680 defaultState;
    protected volatile Function<class_1058, QuadProcessors.Slice> defaultSliceFunc;

    public CtmBlockStateModel(class_1087 wrapped, class_2680 defaultState) {
        super(wrapped);
        this.defaultState = defaultState;
    }

    public void emitQuads(QuadEmitter emitter, class_1920 blockView, class_2338 pos, class_2680 state, class_5819 random, Predicate<@Nullable class_2350> cullTest) {
        if (!((Boolean)ContinuityConfig.INSTANCE.connectedTextures.get()).booleanValue()) {
            super.emitQuads(emitter, blockView, pos, state, random, cullTest);
            return;
        }
        ModelObjectsContainer container = ModelObjectsContainer.get();
        if (!container.featureStates.getConnectedTexturesState().isEnabled()) {
            super.emitQuads(emitter, blockView, pos, state, random, cullTest);
            return;
        }
        CtmQuadTransform quadTransform = container.ctmQuadTransform;
        if (quadTransform.isActive()) {
            super.emitQuads(emitter, blockView, pos, state, random, cullTest);
            return;
        }
        class_2680 appearanceState = state.getAppearance(blockView, pos, class_2350.field_11033, state, pos);
        quadTransform.prepare(blockView, pos, appearanceState, state, state.method_26190(pos), cullTest, this.getSliceFunc(appearanceState));
        emitter.pushTransform((QuadTransform)quadTransform);
        super.emitQuads(emitter, blockView, pos, state, random, cullTest);
        emitter.popTransform();
        quadTransform.processingContext.outputTo(emitter);
        quadTransform.reset();
    }

    @Nullable
    public Object createGeometryKey(class_1920 blockView, class_2338 pos, class_2680 state, class_5819 random) {
        if (!((Boolean)ContinuityConfig.INSTANCE.connectedTextures.get()).booleanValue()) {
            return super.createGeometryKey(blockView, pos, state, random);
        }
        ModelObjectsContainer container = ModelObjectsContainer.get();
        if (!container.featureStates.getConnectedTexturesState().isEnabled()) {
            return super.createGeometryKey(blockView, pos, state, random);
        }
        CtmQuadTransform quadTransform = container.ctmQuadTransform;
        if (quadTransform.isActive()) {
            return super.createGeometryKey(blockView, pos, state, random);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Function<class_1058, QuadProcessors.Slice> getSliceFunc(class_2680 state) {
        if (state == this.defaultState) {
            Function<class_1058, QuadProcessors.Slice> sliceFunc = this.defaultSliceFunc;
            if (sliceFunc == null) {
                CtmBlockStateModel ctmBlockStateModel = this;
                synchronized (ctmBlockStateModel) {
                    sliceFunc = this.defaultSliceFunc;
                    if (sliceFunc == null) {
                        this.defaultSliceFunc = sliceFunc = QuadProcessors.getCache(state);
                    }
                }
            }
            return sliceFunc;
        }
        return QuadProcessors.getCache(state);
    }

    protected static class CtmQuadTransform
    implements QuadTransform {
        protected final ProcessingContextImpl processingContext = new ProcessingContextImpl();
        protected final class_5819 random = class_5819.method_43053();
        protected class_1920 blockView;
        protected class_2338 pos;
        protected class_2680 appearanceState;
        protected class_2680 state;
        protected long randomSeed;
        protected Predicate<@Nullable class_2350> cullTest;
        protected Function<class_1058, QuadProcessors.Slice> sliceFunc;
        protected boolean active;

        protected CtmQuadTransform() {
        }

        public boolean transform(MutableQuadView quad) {
            if (this.cullTest.test(quad.cullFace())) {
                return false;
            }
            for (int pass = 0; pass < 4; ++pass) {
                Boolean result = this.transformOnce(quad, pass);
                if (result == null) continue;
                return result;
            }
            return true;
        }

        protected Boolean transformOnce(MutableQuadView quad, int pass) {
            QuadProcessor[] processors;
            class_1058 sprite = RenderUtil.getSpriteFinder().find((QuadView)quad);
            QuadProcessors.Slice slice = this.sliceFunc.apply(sprite);
            for (QuadProcessor processor : processors = pass == 0 ? slice.processors() : slice.multipassProcessors()) {
                this.random.method_43052(this.randomSeed);
                QuadProcessor.ProcessingResult result = processor.processQuad(quad, sprite, this.blockView, this.pos, this.appearanceState, this.state, this.random, pass, this.processingContext);
                if (result == QuadProcessor.ProcessingResult.NEXT_PROCESSOR) continue;
                if (result == QuadProcessor.ProcessingResult.NEXT_PASS) {
                    return null;
                }
                if (result == QuadProcessor.ProcessingResult.STOP) {
                    return true;
                }
                if (result != QuadProcessor.ProcessingResult.DISCARD) continue;
                return false;
            }
            return true;
        }

        public boolean isActive() {
            return this.active;
        }

        public void prepare(class_1920 blockView, class_2338 pos, class_2680 appearanceState, class_2680 state, long randomSeed, Predicate<@Nullable class_2350> cullTest, Function<class_1058, QuadProcessors.Slice> sliceFunc) {
            this.blockView = blockView;
            this.pos = pos;
            this.appearanceState = appearanceState;
            this.state = state;
            this.randomSeed = randomSeed;
            this.cullTest = cullTest;
            this.sliceFunc = sliceFunc;
            this.active = true;
        }

        public void reset() {
            this.blockView = null;
            this.pos = null;
            this.appearanceState = null;
            this.state = null;
            this.cullTest = null;
            this.sliceFunc = null;
            this.active = false;
            this.processingContext.reset();
        }
    }
}

