/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.common.block.generic;

import com.vetpetmon.wyrmsofnyrus.common.block.AllBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSludgeFluid
extends BlockFluidClassic {
    public BlockSludgeFluid(Fluid fluid, Material material, String name) {
        super(fluid, material);
        this.func_149663_c(name);
        this.setRegistryName(name);
        AllBlocks.ALL_BLOCKS.add((Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        BlockPos abovePos = pos.func_177984_a();
        double d0 = pos.func_177958_n();
        double d1 = pos.func_177956_o();
        double d2 = pos.func_177952_p();
        if (!worldIn.func_180495_p(abovePos).func_185913_b() && !worldIn.func_180495_p(abovePos).func_185914_p()) {
            if (rand.nextInt(100) == 0) {
                double d8 = d0 + (double)rand.nextFloat();
                double d4 = d1 + stateIn.func_185900_c((IBlockAccess)worldIn, (BlockPos)pos).field_72337_e;
                double d6 = d2 + (double)rand.nextFloat();
                worldIn.func_175688_a(EnumParticleTypes.LAVA, d8, d4, d6, 0.0, 0.0, 0.0, new int[0]);
                worldIn.func_184134_a(d8, d4, d6, SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
            }
            if (rand.nextInt(200) == 0) {
                worldIn.func_184134_a(d0, d1, d2, SoundEvents.field_187656_cX, SoundCategory.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
            }
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public Vec3d func_176197_a(World worldIn, BlockPos pos, Entity entityIn, Vec3d motion) {
        Vec3d flowAdder = this.getFlow((IBlockAccess)worldIn, pos, worldIn.func_180495_p(pos));
        return motion.func_178787_e(flowAdder);
    }

    protected Vec3d getFlow(IBlockAccess worldIn, BlockPos pos, IBlockState state) {
        double d0 = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        int i = this.getRenderedDepth(state);
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            blockpos$pooledmutableblockpos.func_189533_g((Vec3i)pos).func_189536_c(enumfacing);
            int j = this.getRenderedDepth(worldIn.func_180495_p((BlockPos)blockpos$pooledmutableblockpos));
            if (j < 0) {
                if (worldIn.func_180495_p((BlockPos)blockpos$pooledmutableblockpos).func_185904_a().func_76230_c() || (j = this.getRenderedDepth(worldIn.func_180495_p(blockpos$pooledmutableblockpos.func_177977_b()))) < 0) continue;
                int k = j - (i - 8);
                d0 += (double)(enumfacing.func_82601_c() * k);
                d1 += (double)(enumfacing.func_96559_d() * k);
                d2 += (double)(enumfacing.func_82599_e() * k);
                continue;
            }
            if (j < 0) continue;
            int l = j - i;
            d0 += (double)(enumfacing.func_82601_c() * l);
            d1 += (double)(enumfacing.func_96559_d() * l);
            d2 += (double)(enumfacing.func_82599_e() * l);
        }
        Vec3d vec3d = new Vec3d(d0, d1, d2);
        if ((Integer)state.func_177229_b((IProperty)LEVEL) >= 8) {
            for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
                blockpos$pooledmutableblockpos.func_189533_g((Vec3i)pos).func_189536_c(enumfacing1);
                if (!this.causesDownwardCurrent(worldIn, (BlockPos)blockpos$pooledmutableblockpos, enumfacing1) && !this.causesDownwardCurrent(worldIn, blockpos$pooledmutableblockpos.func_177984_a(), enumfacing1)) continue;
                vec3d = vec3d.func_72432_b().func_72441_c(0.0, -6.0, 0.0);
                break;
            }
        }
        blockpos$pooledmutableblockpos.func_185344_t();
        return vec3d.func_72432_b();
    }

    protected int getDepth(IBlockState state) {
        return state.func_185904_a() == this.field_149764_J ? (Integer)state.func_177229_b((IProperty)LEVEL) : -1;
    }

    protected int getRenderedDepth(IBlockState state) {
        int i = this.getDepth(state);
        return i >= 8 ? 0 : i;
    }

    public boolean causesDownwardCurrent(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        Material material = iblockstate.func_185904_a();
        if (material == this.field_149764_J) {
            return false;
        }
        if (side == EnumFacing.UP) {
            return true;
        }
        if (material == Material.field_151588_w) {
            return false;
        }
        boolean flag = BlockSludgeFluid.func_193382_c((Block)block) || block instanceof BlockStairs;
        return !flag && iblockstate.func_193401_d(worldIn, pos, side) == BlockFaceShape.SOLID;
    }
}

