/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.common.block.hivecreep;

import com.vetpetmon.synlib.client.rendering.IHasModel;
import com.vetpetmon.synlib.core.util.RNG;
import com.vetpetmon.wyrmsofnyrus.WyrmsOfNyrus;
import com.vetpetmon.wyrmsofnyrus.common.block.AllBlocks;
import com.vetpetmon.wyrmsofnyrus.common.block.BlockMaterials;
import com.vetpetmon.wyrmsofnyrus.common.config.Invasion;
import com.vetpetmon.wyrmsofnyrus.common.config.WorldConfig;
import com.vetpetmon.wyrmsofnyrus.common.entity.ai.gestalt.GestaltHostMind;
import com.vetpetmon.wyrmsofnyrus.common.invasion.HiveCreepSpreadFurther;
import com.vetpetmon.wyrmsofnyrus.common.item.AllItems;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockHivecreepBase
extends Block
implements IHasModel {
    public static PropertyInteger ACTIVE = PropertyInteger.func_177719_a((String)"active", (int)0, (int)1);
    protected Block decaysInto;

    public BlockHivecreepBase(String name, float hardness, float blastresist, Block decaysInto) {
        super(BlockMaterials.CREEP);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149711_c(hardness);
        this.func_149752_b(blastresist);
        this.func_149672_a(SoundType.field_185859_l);
        this.setDecaysInto(decaysInto);
        this.func_149647_a(WyrmsOfNyrus.wyrmTabs);
        AllBlocks.ALL_BLOCKS.add(this);
        AllItems.ALL_ITEMS.add((Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
    }

    public Block setToolStats(String effectiveTool, int toolLevel) {
        this.setHarvestLevel(effectiveTool, toolLevel);
        return this;
    }

    public void setDecaysInto(Block decaysInto) {
        this.decaysInto = decaysInto;
    }

    public Block getDecaysInto() {
        return this.decaysInto;
    }

    public int func_149738_a(World world) {
        if (GestaltHostMind.infamyIsMaxed) {
            return Invasion.creepTickRate * 2;
        }
        return Invasion.creepTickRate;
    }

    public void registerModels() {
        WyrmsOfNyrus.proxy.registerItemRenderer(Item.func_150898_a((Block)this), 0, "inventory");
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ACTIVE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)ACTIVE);
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ACTIVE});
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
    }

    @ParametersAreNonnullByDefault
    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return WorldConfig.creepBlocksStopSpawns;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        super.func_180650_b(world, pos, state, random);
        int active = (Integer)state.func_177229_b((IProperty)ACTIVE);
        if (world.func_175623_d(pos.func_177984_a()) && Objects.equals(this.getRegistryName(), new ResourceLocation("wyrmsofnyrus:hivecreepblock"))) {
            if (active == 0) {
                world.func_180501_a(pos, AllBlocks.hivecreeptop.func_176223_P().func_177226_a((IProperty)ACTIVE, (Comparable)Integer.valueOf(active)), 3);
            } else {
                world.func_180501_a(pos, AllBlocks.hivecreeptop.func_176223_P().func_177226_a((IProperty)ACTIVE, (Comparable)Integer.valueOf(1)), 3);
            }
        }
        if (RNG.getIntRangeInclu((int)0, (int)WorldConfig.hivecreepDecorationDensity) == WorldConfig.hivecreepDecorationDensity && WorldConfig.hivecreepDecoEnabled && Objects.equals(this.getRegistryName(), AllBlocks.hivecreeptop.getRegistryName()) && world.func_175623_d(pos.func_177984_a())) {
            world.func_180501_a(pos.func_177984_a(), AllBlocks.creepedSpores.func_176223_P(), 3);
        }
        if (active == 1) {
            HiveCreepSpreadFurther.spread(pos, world, this.getDecaysInto());
        } else {
            HiveCreepSpreadFurther.decay(pos, world, this.getDecaysInto());
        }
        world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
    }
}

