/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.common.config;

import com.vetpetmon.synlib.core.util.CFG;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.Configuration;

@Config(modid="wyrmsofnyrus", name="Wyrms of Nyrus Client")
public class Client {
    @Config.Name(value="Fancy Animations")
    @Config.Comment(value={"Enables extensive animation value checks for situations like being in the air (for non-flying enemies) or being in water (for non-aquatic enemies).", "Disabling this can increase performance on clients."})
    public static boolean fancyAnimations = true;
    @Config.Name(value="Motion Shake")
    @Config.Comment(value={"Enables or disables screenshake effects.", "Accessibility: Disabling this helps reduce motion sickness."})
    public static boolean moShake = true;
    @Config.Name(value="Don't Greet Me")
    @Config.Comment(value={"Enables or disables the first time-greeting message if a factory preset went missing, this is a workaround if you are on OpenJDK."})
    public static boolean firstTimeBoot = true;
    @Config.Name(value="Music Enabled")
    @Config.Comment(value={"Enables or disables the music that plays when various events happen, including invasion stage changes and Wyrmfollies hunting the player.The music is streamed by Wyrms of Nyrus, so it is not pre-loaded into memory first thing. There may be lag when music tracks start, so this option is available for users.Turn this off if you are a server, not a client. Calls to play tracks will still be sent out from servers to client, but the server itself will not play the songs.This option should ONLY have a memory usage impact when music tracks are streamed. If the music tracks are eating your RAM, disable this and report the memory leak to VPML immediately."})
    public static boolean MusicEnabled = true;
    @Config.Name(value="Config Preset")
    @Config.Comment(value={"The index of the configuration preset you wish to use.", "Setting this to -1 will make the mod use this version's default configurations.", "Factory presets are defined in a range from 0 to 2, with increasing difficulty. Any value above this will use user-defined configurations.", "0 = Arcade, a fast-paced invasion balanced around vanilla and WoN by itself. A great introduction to the mod.", "1 = Classic, medium-low difficulty, best suited for modpacks with multiple weapon/gear mods like Tinker's Construct; all features enabled.", "2 = Dark Forest, emulates the canonical power of the Nyral Wyrms while still being playable. Balanced for mods like HBM's Nuclear Tech Mod and the Scape and Run mod series; all extremely destructive features are enabled. Not for the faint of heart!"})
    @Config.RequiresMcRestart
    @Config.RangeInt(min=-1, max=255)
    public static int configPreset = -1;
    @Config.Name(value="Full Motion Shake")
    @Config.Comment(value={"Uses the experimental screen shake algorithm, which may be more expensive for lower-end hardware.", "Setting this to false will make the screen shake function identically to how it appears pre-v0.7.12"})
    public static boolean moShakeMode = false;

    @Deprecated
    public static void loadFromConfig(Configuration config) {
        String CATEGORY = "Clientside";
        config.addCustomCategoryComment("Clientside", "\nUser-end settings. Can be reloaded at any point in time.\n");
        fancyAnimations = CFG.createConfigBool((Configuration)config, (String)"Clientside", (String)"Enable fancy animations", (String)"Allows for extra animations to be played for certain wyrms that have more than 2-3 animations, reduces the amount of conditionals being checked and might help with FPS on lower end PCs. Default: true", (boolean)true);
    }
}

