/*
 * Decompiled with CFR 0.152.
 */
package com.vetpetmon.wyrmsofnyrus.common.entity;

import com.vetpetmon.wyrmsofnyrus.common.entity.EntityWyrm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class EntityWyrmFlying
extends EntityWyrm
implements IMob {
    protected static DataParameter<Boolean> HAS_TARGET = EntityDataManager.func_187226_a(EntityWyrmFlying.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityWyrmFlying(World worldIn) {
        super(worldIn);
        this.field_70178_ae = false;
    }

    @Override
    public void func_70636_d() {
        if (this.func_110143_aJ() <= 0.0f) {
            this.field_70181_x *= (double)-0.3f;
        }
        super.func_70636_d();
    }

    protected SoundEvent func_184588_d(int heightIn) {
        return null;
    }

    public void func_189654_d(boolean ignored) {
        if (this.getVariant().canFly()) {
            super.func_189654_d(true);
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public static float rotate(float ang, float goalAngle, float maxIncrease) {
        float f = MathHelper.func_76142_g((float)(goalAngle - ang));
        if (f > maxIncrease) {
            f = maxIncrease;
        } else if (f < -maxIncrease) {
            f = -maxIncrease;
        }
        return ang + f;
    }

    public static void rotationPW(Vec3d pos, EntityWyrmFlying entity, float maxYawIncrease, float maxPitchIncrease) {
        double d0 = pos.field_72450_a - entity.field_70165_t;
        double d2 = pos.field_72449_c - entity.field_70161_v;
        double d1 = pos.field_72448_b - entity.field_70163_u;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
        float f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
        entity.field_70125_A = EntityWyrmFlying.rotate(entity.field_70125_A, f1, maxPitchIncrease);
        entity.field_70177_z = EntityWyrmFlying.rotate(entity.field_70177_z, f, maxYawIncrease);
    }

    public Vec3d getRandomVec3d(float range) {
        return new Vec3d((double)this.rngF(range), (double)this.rngF(range), (double)this.rngF(range));
    }

    public List<Vec3d> getAABBcorners(AxisAlignedBB bb) {
        return new ArrayList<Vec3d>(Arrays.asList(new Vec3d(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f), new Vec3d(bb.field_72336_d, bb.field_72337_e, bb.field_72339_c), new Vec3d(bb.field_72336_d, bb.field_72338_b, bb.field_72334_f), new Vec3d(bb.field_72336_d, bb.field_72338_b, bb.field_72339_c), new Vec3d(bb.field_72340_a, bb.field_72337_e, bb.field_72334_f), new Vec3d(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c), new Vec3d(bb.field_72340_a, bb.field_72338_b, bb.field_72334_f), new Vec3d(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c)));
    }

    private float rngF(float range) {
        return this.field_70146_Z.nextFloat() * (float)(this.field_70146_Z.nextInt(2) == 0 ? 1 : -1) * range;
    }

    private static Vec3d rotV2(Vec3d v, Vec3d k, double deg) {
        double t = Math.toRadians(deg);
        k = k.func_72432_b();
        return v.func_186678_a(Math.cos(t)).func_178787_e(k.func_72431_c(v).func_186678_a(Math.sin(t))).func_178787_e(k.func_186678_a(k.func_72430_b(v)).func_186678_a(1.0 - Math.cos(t)));
    }

    public static Vec3d crossPlane(Vec3d vec, Vec3d plane) {
        return EntityWyrmFlying.rotV2(vec.func_72431_c(plane), plane, 90.0);
    }

    public static void gliderTravel(EntityWyrmFlying entity, float strafe, float vertical, float forward) {
        double drag;
        double d = drag = entity.func_70090_H() || entity.func_180799_ab() ? 0.6 : 1.0;
        if (drag < 1.0) {
            entity.func_191958_b(strafe, vertical, forward, 0.02f);
            entity.func_70091_d(MoverType.SELF, entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
            entity.field_70159_w *= drag;
            entity.field_70181_x *= drag;
            entity.field_70179_y *= drag;
        } else {
            float f = 0.91f;
            if (entity.field_70122_E) {
                BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)entity.field_70165_t), MathHelper.func_76128_c((double)entity.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)entity.field_70161_v));
                IBlockState underState = entity.field_70170_p.func_180495_p(underPos);
                f = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)entity.field_70170_p, underPos, (Entity)entity) * 0.91f;
            }
            float f1 = 0.16277136f / (f * f * f);
            entity.func_191958_b(strafe, vertical, forward, entity.field_70122_E ? 0.1f * f1 : 0.02f);
            f = 0.91f;
            if (entity.field_70122_E) {
                BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)entity.field_70165_t), MathHelper.func_76128_c((double)entity.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)entity.field_70161_v));
                IBlockState underState = entity.field_70170_p.func_180495_p(underPos);
                f = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)entity.field_70170_p, underPos, (Entity)entity) * 0.91f;
            }
            entity.func_70091_d(MoverType.SELF, entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
            entity.field_70159_w *= (double)f;
            entity.field_70181_x *= (double)f;
            entity.field_70179_y *= (double)f;
        }
        entity.field_184618_aE = entity.field_70721_aZ;
        double d1 = entity.field_70165_t - entity.field_70169_q;
        double d0 = entity.field_70161_v - entity.field_70166_s;
        float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        entity.field_70721_aZ += (f2 - entity.field_70721_aZ) * 0.4f;
        entity.field_184619_aG += entity.field_70721_aZ;
    }

    public class FlyingAIGlide
    extends EntityAIBase {
        private final EntityWyrmFlying entity;
        @Nullable
        private Vec3d planeVectorPath = this.getNewPlaneVector();
        private final boolean considerLiquid;
        private final float stayAbove;
        private final float radius;
        private final float rngFRange;

        public FlyingAIGlide(EntityWyrmFlying entity, float radius, float rngFRange, boolean considerLiquid) {
            this.entity = entity;
            this.radius = radius;
            this.rngFRange = rngFRange;
            this.considerLiquid = considerLiquid;
            this.stayAbove = 0.0f;
            this.func_75248_a(3);
        }

        public FlyingAIGlide(EntityWyrmFlying entity, float radius, float rngFRange, boolean considerLiquid, float stayAbove) {
            this.entity = entity;
            this.radius = radius;
            this.rngFRange = rngFRange;
            this.considerLiquid = considerLiquid;
            this.stayAbove = stayAbove;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            return this.entity.func_70638_az() != null;
        }

        public void func_75246_d() {
            if (this.entity.func_70638_az() != null) {
                Vec3d target = this.entity.func_70638_az().func_174791_d();
                Vec3d goal = this.getNextPoint(target);
                Vec3d dir = goal.func_178788_d(this.entity.func_174791_d()).func_72432_b().func_186678_a(0.15);
                dir.func_186678_a((double)0.05f * (this.entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() / 2.0));
                if (this.stayAbove > 0.0f && dir.field_72448_b < dir.field_72448_b + (double)this.stayAbove) {
                    this.entity.func_70024_g(dir.field_72450_a, dir.field_72448_b + 0.25, dir.field_72449_c);
                } else {
                    this.entity.func_70024_g(dir.field_72450_a, dir.field_72448_b, dir.field_72449_c);
                }
                EntityWyrmFlying.rotationPW(goal, this.entity, 10.0f, 10.0f);
                this.entity.func_70671_ap().func_75650_a(dir.field_72450_a, dir.field_72448_b, dir.field_72449_c, 3.0f, 3.0f);
            }
        }

        private Vec3d getNewPlaneVector() {
            return new Vec3d(0.0, 1.0, 0.0).func_178787_e(new Vec3d((double)EntityWyrmFlying.this.rngF(this.rngFRange), (double)EntityWyrmFlying.this.rngF(this.rngFRange), (double)EntityWyrmFlying.this.rngF(this.rngFRange)).func_186678_a(2.0)).func_72432_b();
        }

        private boolean hasClearPath(Vec3d nextPointToFollow) {
            return EntityWyrmFlying.this.getAABBcorners(this.entity.func_174813_aQ()).stream().noneMatch(vec3d -> this.lineBlocked((Vec3d)vec3d, nextPointToFollow));
        }

        private boolean lineBlocked(Vec3d start, Vec3d nextPointToFollow) {
            RayTraceResult rayTraceResult = this.entity.field_70170_p.func_147447_a(start, nextPointToFollow, this.considerLiquid, true, false);
            return rayTraceResult != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK;
        }

        private Vec3d getNextPoint(Vec3d center) {
            Vec3d central = this.entity.func_174791_d().func_178787_e(EntityWyrmFlying.this.getRandomVec3d(this.rngFRange));
            int i = 0;
            while ((float)i < this.radius) {
                for (int sign : new int[]{1, -1}) {
                    Vec3d vel = this.entity.getVelocity();
                    Vec3d dir = this.entity.func_174791_d().func_178788_d(center);
                    Vec3d predicteddir = EntityWyrmFlying.crossPlane(dir, this.planeVectorPath).func_72432_b().func_186678_a((double)(this.radius + (float)(i * sign)));
                    Vec3d nextPos = EntityWyrmFlying.rotV2(predicteddir, this.planeVectorPath, 2.0 * vel.func_72433_c());
                    central = nextPos.func_178787_e(center);
                    if (this.hasClearPath(central)) {
                        return central;
                    }
                    this.planeVectorPath = this.getNewPlaneVector();
                }
                ++i;
            }
            return central;
        }
    }

    public static class FlyingAI
    extends EntityAIBase {
        private final EntityWyrmFlying parentEntity;

        public FlyingAI(EntityWyrmFlying e) {
            this.parentEntity = e;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            EntityMoveHelper entitymovehelper = this.parentEntity.func_70605_aq();
            if (!entitymovehelper.func_75640_a()) {
                return true;
            }
            double d0 = entitymovehelper.func_179917_d() - this.parentEntity.field_70165_t;
            double d3 = d0 * d0 + (d1 = entitymovehelper.func_179919_e() - this.parentEntity.field_70163_u) * d1 + (d2 = entitymovehelper.func_179918_f() - this.parentEntity.field_70161_v) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random rng = this.parentEntity.func_70681_au();
            double d0 = this.parentEntity.field_70165_t + (double)((rng.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.parentEntity.field_70163_u + (double)((rng.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.parentEntity.field_70161_v + (double)((rng.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, 3.05);
        }

        public void func_75246_d() {
            Vec3d pos = this.parentEntity.getVelocity().func_72432_b().func_186678_a(5.0).func_178787_e(this.parentEntity.func_174791_d());
            double d0 = pos.field_72450_a - this.parentEntity.field_70165_t;
            double d2 = pos.field_72449_c - this.parentEntity.field_70161_v;
            double d1 = pos.field_72448_b - this.parentEntity.field_70163_u;
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
            float f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
            this.parentEntity.field_70125_A = EntityWyrmFlying.rotate(this.parentEntity.field_70125_A, f1, 11.0f);
            this.parentEntity.field_70177_z = EntityWyrmFlying.rotate(this.parentEntity.field_70177_z, f, 11.0f);
            this.parentEntity.func_70671_ap().func_75650_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 3.0f, 3.0f);
            super.func_75246_d();
        }
    }
}

